/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import pojos.CategoryData;
import pojos.CategoryGroupData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.GroupData;
import pojos.ProjectData;

public class DMRefreshLoader
extends BatchCallTree {
    private Object results;
    private BatchCall loadCall;

    private void checkRootLevel(Class level) {
        if (level.equals(ExperimenterData.class) || level.equals(GroupData.class)) {
            return;
        }
        throw new IllegalArgumentException("Root level not supported");
    }

    private BatchCall makeBatchCall(final Class rootNodeType, final List containerWithImages, final Class rootLevel, final long rootLevelID) {
        return new BatchCall("Loading container tree: "){

            public void doCall() throws Exception {
                OmeroDataService os = DMRefreshLoader.this.context.getDataService();
                Set set = os.loadContainerHierarchy(rootNodeType, null, false, rootLevel, rootLevelID);
                Iterator i = containerWithImages.iterator();
                HashSet<Long> ids = new HashSet<Long>(containerWithImages.size());
                while (i.hasNext()) {
                    ids.add(new Long(((DataObject)i.next()).getId()));
                }
                Iterator j = set.iterator();
                HashSet<DataObject> children = null;
                Class<CategoryData> klass = null;
                HashMap topNodes = new HashMap(set.size());
                while (j.hasNext()) {
                    HashSet newChildren = new HashSet();
                    DataObject parent = (DataObject)j.next();
                    if (parent instanceof ProjectData) {
                        children = ((ProjectData)parent).getDatasets();
                        klass = DatasetData.class;
                    } else if (parent instanceof CategoryGroupData) {
                        klass = CategoryData.class;
                        children = ((CategoryGroupData)parent).getCategories();
                    } else if (parent instanceof DatasetData) {
                        children = new HashSet<DataObject>(1);
                        children.add(parent);
                        klass = DatasetData.class;
                    } else if (parent instanceof CategoryData) {
                        children = new HashSet(1);
                        children.add(parent);
                        klass = CategoryData.class;
                    }
                    topNodes.put(parent, newChildren);
                    for (DataObject child : children) {
                        Long id = new Long(child.getId());
                        if (ids.contains(id)) {
                            HashSet<Long> cIds = new HashSet<Long>(1);
                            cIds.add(id);
                            Set r = os.loadContainerHierarchy(klass, cIds, true, rootLevel, rootLevelID);
                            Iterator k = r.iterator();
                            while (k.hasNext()) {
                                newChildren.add(k.next());
                            }
                            continue;
                        }
                        newChildren.add(child);
                    }
                }
                DMRefreshLoader.this.results = topNodes;
            }
        };
    }

    protected void buildTree() {
        this.add(this.loadCall);
    }

    protected Object getResult() {
        return this.results;
    }

    public DMRefreshLoader(Class rootNodeType, List containerWithImages, Class rootLevel, long rootLevelID) {
        if (rootNodeType == null) {
            throw new IllegalArgumentException("No root node type.");
        }
        this.checkRootLevel(rootLevel);
        if (rootLevelID < 0L) {
            throw new IllegalArgumentException("No root ID not valid.");
        }
        if (containerWithImages == null || containerWithImages.size() == 0) {
            throw new IllegalArgumentException("No container with images.");
        }
        if (!rootNodeType.equals(ProjectData.class) && !rootNodeType.equals(CategoryGroupData.class)) {
            throw new IllegalArgumentException("Unsupported type: " + rootNodeType);
        }
        this.loadCall = this.makeBatchCall(rootNodeType, containerWithImages, rootLevel, rootLevelID);
    }
}

