/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.Set;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import pojos.CategoryData;
import pojos.CategoryGroupData;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.GroupData;
import pojos.ProjectData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DMLoader
extends BatchCallTree {
    private Set results;
    private BatchCall loadCall;

    private void checkRootLevel(Class level) {
        if (level.equals(ExperimenterData.class) || level.equals(GroupData.class)) {
            return;
        }
        throw new IllegalArgumentException("Root level not supported");
    }

    private BatchCall makeBatchCall(final Class rootNodeType, final Set rootNodeIDs, final boolean withLeaves, final Class rootLevel, final long rootLevelID) {
        return new BatchCall("Loading container tree: "){

            public void doCall() throws Exception {
                OmeroDataService os = DMLoader.this.context.getDataService();
                DMLoader.this.results = os.loadContainerHierarchy(rootNodeType, rootNodeIDs, withLeaves, rootLevel, rootLevelID);
            }
        };
    }

    @Override
    protected void buildTree() {
        this.add(this.loadCall);
    }

    @Override
    protected Object getResult() {
        return this.results;
    }

    public DMLoader(Class rootNodeType, Set<Long> rootNodeIDs, boolean withLeaves, Class rootLevel, long rootLevelID) {
        if (rootNodeType == null) {
            throw new IllegalArgumentException("No root node type.");
        }
        this.checkRootLevel(rootLevel);
        if (rootLevelID < 0L) {
            throw new IllegalArgumentException("No root ID not valid.");
        }
        if (!(rootNodeType.equals(ProjectData.class) || rootNodeType.equals(DatasetData.class) || rootNodeType.equals(CategoryGroupData.class) || rootNodeType.equals(CategoryData.class))) {
            throw new IllegalArgumentException("Unsupported type: " + rootNodeType);
        }
        this.loadCall = this.makeBatchCall(rootNodeType, rootNodeIDs, withLeaves, rootLevel, rootLevelID);
    }
}

