/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import pojos.CategoryData;
import pojos.DataObject;
import pojos.DatasetData;

public class ContainerCounterLoader
extends BatchCallTree {
    private Map currentMap;
    private Set rootIDs;

    protected void buildTree() {
        Iterator i = this.rootIDs.iterator();
        Long id = null;
        Class<DatasetData> rootType = null;
        while (i.hasNext()) {
            DataObject root = (DataObject)i.next();
            if (root instanceof DatasetData) {
                rootType = DatasetData.class;
                id = new Long(((DatasetData)root).getId());
            } else if (root instanceof CategoryData) {
                rootType = CategoryData.class;
                id = new Long(((CategoryData)root).getId());
            }
            if (id == null) continue;
            String description = "Loading number of items for container: " + id.intValue();
            final Long idFinal = id;
            final Class<DatasetData> rootTypeFinal = rootType;
            this.add(new BatchCall(description){

                public void doCall() throws Exception {
                    HashSet<Long> ids = new HashSet<Long>(1);
                    ids.add(idFinal);
                    OmeroDataService os = ContainerCounterLoader.this.context.getDataService();
                    ContainerCounterLoader.this.currentMap = os.getCollectionCount(rootTypeFinal, "images", ids);
                }
            });
        }
    }

    protected Object getPartialResult() {
        return this.currentMap;
    }

    protected Object getResult() {
        return null;
    }

    public ContainerCounterLoader(Set rootIDs) {
        if (rootIDs == null) {
            throw new NullPointerException("No root nodes.");
        }
        try {
            rootIDs.toArray(new DataObject[0]);
        }
        catch (ArrayStoreException ase) {
            throw new IllegalArgumentException("rootIDs only contains DataObject.");
        }
        this.rootIDs = rootIDs;
    }
}

