/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.Set;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import pojos.CategoryData;
import pojos.DataObject;
import pojos.ImageData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassificationSaver
extends BatchCallTree {
    private BatchCall saveCall;
    private Object result;

    private BatchCall classify(final Set images, final Set categories) {
        return new BatchCall("Saving classification tree."){

            public void doCall() throws Exception {
                OmeroDataService os = ClassificationSaver.this.context.getDataService();
                ClassificationSaver.this.result = os.classify(images, categories);
            }
        };
    }

    private BatchCall classifyChildren(final Set containers, final Set categories) {
        return new BatchCall("Saving classification tree."){

            public void doCall() throws Exception {
                OmeroDataService os = ClassificationSaver.this.context.getDataService();
                ClassificationSaver.this.result = os.classifyChildren(containers, categories);
            }
        };
    }

    private BatchCall declassify(final Set images, final Set categories) {
        return new BatchCall("Declassifying images."){

            public void doCall() throws Exception {
                OmeroDataService os = ClassificationSaver.this.context.getDataService();
                ClassificationSaver.this.result = os.declassify(images, categories);
            }
        };
    }

    @Override
    protected void buildTree() {
        this.add(this.saveCall);
    }

    @Override
    protected Object getResult() {
        return this.result;
    }

    public ClassificationSaver(Set<ImageData> images, Set<CategoryData> categories, boolean classify) {
        if (images == null) {
            throw new IllegalArgumentException("No images to classify or declassify.");
        }
        if (categories == null) {
            throw new NullPointerException("No category to add to or remove from.");
        }
        this.saveCall = classify ? this.classify(images, categories) : this.declassify(images, categories);
    }

    public ClassificationSaver(Set<DataObject> containers, Set<CategoryData> categories) {
        if (containers == null) {
            throw new IllegalArgumentException("No images to classify or declassify.");
        }
        if (categories == null) {
            throw new NullPointerException("No category to add to or remove from.");
        }
        this.saveCall = this.classifyChildren(containers, categories);
    }
}

