/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.HashSet;
import java.util.Set;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import pojos.CategoryGroupData;

public class ClassificationLoader
extends BatchCallTree {
    public static final int DECLASSIFICATION = 0;
    public static final int CLASSIFICATION_ME = 1;
    public static final int CLASSIFICATION_NME = 2;
    private Set rootNodes;
    private BatchCall loadCall;

    private boolean checkAlgorithmIndex(int i) {
        switch (i) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    private BatchCall loadCGCPaths(final Set imageIDs, final int algorithm, final Class rootLevel, final long rootLevelID) {
        return new BatchCall("Loading CGC paths. "){

            public void doCall() throws Exception {
                OmeroDataService os = ClassificationLoader.this.context.getDataService();
                if (algorithm == 2) {
                    ClassificationLoader.this.rootNodes = os.loadContainerHierarchy(CategoryGroupData.class, null, false, rootLevel, rootLevelID);
                } else {
                    ClassificationLoader.this.rootNodes = os.findCGCPaths(imageIDs, algorithm, rootLevel, rootLevelID);
                }
            }
        };
    }

    protected void buildTree() {
        this.add(this.loadCall);
    }

    protected Object getResult() {
        return this.rootNodes;
    }

    public ClassificationLoader(long imageID, int algorithm, Class rootLevel, long rootLevelID) {
        if (imageID < 0L) {
            throw new IllegalArgumentException("image ID not valid ");
        }
        if (!this.checkAlgorithmIndex(algorithm)) {
            throw new IllegalArgumentException("Algorithm not supported.");
        }
        HashSet<Long> set = new HashSet<Long>(1);
        set.add(new Long(imageID));
        this.loadCall = this.loadCGCPaths(set, algorithm, rootLevel, rootLevelID);
    }

    public ClassificationLoader(Set imageIDs, int algorithm, Class rootLevel, long rootLevelID) {
        if ((imageIDs == null || imageIDs.size() == 0) && algorithm == 0) {
            throw new IllegalArgumentException("The collection of idscannot be null or of size 0.");
        }
        if (!this.checkAlgorithmIndex(algorithm)) {
            throw new IllegalArgumentException("Algorithm not supported.");
        }
        this.loadCall = this.loadCGCPaths(imageIDs, algorithm, rootLevel, rootLevelID);
    }
}

