/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import pojos.AnnotationData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ImageData;

public class AnnotationSaver
extends BatchCallTree {
    public static final int CREATE = 0;
    public static final int UPDATE = 1;
    public static final int DELETE = 2;
    private BatchCall saveCall;
    private List result;

    private BatchCall updateAndCreateAnnotation(final Map toUpdate, final Set toCreate, final AnnotationData data) {
        return new BatchCall("Remove dataset annotation."){

            public void doCall() throws Exception {
                OmeroDataService os = AnnotationSaver.this.context.getDataService();
                AnnotationSaver.this.result = new ArrayList();
                AnnotationSaver.this.result.add(os.updateAnnotationFor(toUpdate));
                AnnotationSaver.this.result.add(os.createAnnotationFor(toCreate, data));
            }
        };
    }

    private BatchCall updateAnnotation(final Map objects) {
        return new BatchCall("Update image annotation."){

            public void doCall() throws Exception {
                OmeroDataService os = AnnotationSaver.this.context.getDataService();
                AnnotationSaver.this.result = os.updateAnnotationFor(objects);
            }
        };
    }

    private BatchCall createAnnotation(final Set objects, final AnnotationData data) {
        return new BatchCall("Create dataset annotation."){

            public void doCall() throws Exception {
                OmeroDataService os = AnnotationSaver.this.context.getDataService();
                AnnotationSaver.this.result = os.createAnnotationFor(objects, data);
            }
        };
    }

    private BatchCall removeAnnotation(final DataObject object, final AnnotationData data) {
        return new BatchCall("Remove dataset annotation."){

            public void doCall() throws Exception {
                OmeroDataService os = AnnotationSaver.this.context.getDataService();
                AnnotationSaver.this.result = new ArrayList(1);
                AnnotationSaver.this.result.add(os.removeAnnotationFrom(object, data));
            }
        };
    }

    private BatchCall removeAnnotation(final DataObject object, final List data) {
        return new BatchCall("Remove dataset annotation."){

            public void doCall() throws Exception {
                OmeroDataService os = AnnotationSaver.this.context.getDataService();
                AnnotationSaver.this.result = new ArrayList(1);
                AnnotationSaver.this.result.add(os.removeAnnotationFrom(object, data));
            }
        };
    }

    private BatchCall updateAnnotation(final DataObject object, final AnnotationData data) {
        return new BatchCall("Update image annotation."){

            public void doCall() throws Exception {
                OmeroDataService os = AnnotationSaver.this.context.getDataService();
                AnnotationSaver.this.result = new ArrayList(1);
                AnnotationSaver.this.result.add(os.updateAnnotationFor(object, data));
            }
        };
    }

    private BatchCall createAnnotation(final DataObject object, final AnnotationData data) {
        return new BatchCall("Create dataset annotation."){

            public void doCall() throws Exception {
                OmeroDataService os = AnnotationSaver.this.context.getDataService();
                AnnotationSaver.this.result = new ArrayList(1);
                AnnotationSaver.this.result.add(os.createAnnotationFor(object, data));
            }
        };
    }

    private BatchCall annotateChildren(final Set objects, final AnnotationData data) {
        return new BatchCall("Create dataset annotation."){

            public void doCall() throws Exception {
                OmeroDataService os = AnnotationSaver.this.context.getDataService();
                AnnotationSaver.this.result = os.annotateChildren(objects, data);
            }
        };
    }

    protected void buildTree() {
        this.add(this.saveCall);
    }

    protected Object getResult() {
        return this.result;
    }

    public AnnotationSaver(DataObject annotatedObject, AnnotationData data, int algorithm) {
        if (data == null) {
            throw new IllegalArgumentException("No annotation.");
        }
        if (annotatedObject == null) {
            throw new IllegalArgumentException("No DataObject to annotate.");
        }
        if (!(annotatedObject instanceof DatasetData) && !(annotatedObject instanceof ImageData)) {
            throw new IllegalArgumentException("DataObject cannot be annotated.");
        }
        switch (algorithm) {
            case 2: {
                this.saveCall = this.removeAnnotation(annotatedObject, data);
                break;
            }
            case 1: {
                this.saveCall = this.updateAnnotation(annotatedObject, data);
                break;
            }
            case 0: {
                this.saveCall = this.createAnnotation(annotatedObject, data);
                break;
            }
            default: {
                throw new IllegalArgumentException("Constructor should onlybe invoked to update or delete annotation.");
            }
        }
    }

    public AnnotationSaver(DataObject annotatedObject, List data, int algorithm) {
        if (data == null) {
            throw new IllegalArgumentException("No annotation.");
        }
        if (annotatedObject == null) {
            throw new IllegalArgumentException("No DataObject to annotate.");
        }
        if (!(annotatedObject instanceof DatasetData) && !(annotatedObject instanceof ImageData)) {
            throw new IllegalArgumentException("DataObject cannot be annotated.");
        }
        switch (algorithm) {
            case 2: {
                this.saveCall = this.removeAnnotation(annotatedObject, data);
                break;
            }
            default: {
                throw new IllegalArgumentException("Constructor should onlybe invoked to update or delete annotation.");
            }
        }
    }

    public AnnotationSaver(Set set, AnnotationData data, boolean children) {
        if (data == null) {
            throw new IllegalArgumentException("No annotation.");
        }
        if (set == null || set.size() == 0) {
            throw new IllegalArgumentException("No DataObject to annotate.");
        }
        this.saveCall = children ? this.annotateChildren(set, data) : this.createAnnotation(set, data);
    }

    public AnnotationSaver(Map toUpdate) {
        if (toUpdate == null || toUpdate.size() == 0) {
            throw new IllegalArgumentException("No DataObject to annotate.");
        }
        this.saveCall = this.updateAnnotation(toUpdate);
    }

    public AnnotationSaver(Map toUpdate, Set toCreate, AnnotationData data) {
        if (toUpdate == null || toUpdate.size() == 0) {
            throw new IllegalArgumentException("No DataObject to annotate.");
        }
        if (data == null) {
            throw new IllegalArgumentException("No annotation.");
        }
        if (toCreate == null || toCreate.size() == 0) {
            throw new IllegalArgumentException("No DataObject to annotate.");
        }
        this.saveCall = this.updateAndCreateAnnotation(toUpdate, toCreate, data);
    }
}

