/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import pojos.DatasetData;
import pojos.ImageData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationLoader
extends BatchCallTree {
    private Map annotations;
    private BatchCall loadCall;

    private void validate(Class nodeType, Set<Long> nodeIDs, boolean forUser) {
        if (nodeType == null) {
            throw new IllegalArgumentException("No node type.");
        }
        if (nodeIDs == null || nodeIDs.size() == 0) {
            throw new IllegalArgumentException("No root node ids.");
        }
        if (!nodeType.equals(DatasetData.class) && !nodeType.equals(ImageData.class)) {
            throw new IllegalArgumentException("DataObject not supported.");
        }
        this.loadCall = this.makeAnnotationBatchCall(nodeType, nodeIDs, forUser);
    }

    private BatchCall makeAnnotationBatchCall(final Class nodeType, final Set nodeIDs, final boolean forUser) {
        return new BatchCall("Loading annotation"){

            public void doCall() throws Exception {
                OmeroDataService os = AnnotationLoader.this.context.getDataService();
                AnnotationLoader.this.annotations = os.findAnnotations(nodeType, nodeIDs, null, forUser);
            }
        };
    }

    @Override
    protected void buildTree() {
        this.add(this.loadCall);
    }

    @Override
    protected Object getResult() {
        return this.annotations;
    }

    public AnnotationLoader(Class nodeType, long nodeID, boolean forUser) {
        HashSet<Long> set = new HashSet<Long>(1);
        set.add(new Long(nodeID));
        this.validate(nodeType, set, forUser);
    }

    public AnnotationLoader(Class nodeType, Set<Long> nodeIDs, boolean forUser) {
        this.validate(nodeType, nodeIDs, forUser);
    }
}

