/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.Iterator;
import java.util.List;
import ome.model.core.Pixels;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import org.openmicroscopy.shoola.env.rnd.PixelsServicesFactory;
import org.openmicroscopy.shoola.env.rnd.data.DataSink;
import org.openmicroscopy.shoola.env.rnd.roi.ROIAnalyser;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;

public class Analyser
extends BatchCallTree {
    private final Pixels pixels;
    private final List channels;
    private Object result;
    private BatchCall loadCall;

    private BatchCall analyseShapes(final ROIShape[] shapes) {
        return new BatchCall("Analysing shapes"){

            public void doCall() throws Exception {
                DataSink sink = PixelsServicesFactory.createDataSink(Analyser.this.pixels);
                ROIAnalyser analyser = new ROIAnalyser(sink, Analyser.this.pixels.getSizeZ(), Analyser.this.pixels.getSizeT(), Analyser.this.pixels.getSizeC());
                try {
                    Analyser.this.result = analyser.analyze(shapes, Analyser.this.channels);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
    }

    protected void buildTree() {
        this.add(this.loadCall);
    }

    protected Object getResult() {
        return this.result;
    }

    public Analyser(Pixels pixels, List channels, List shapes) {
        if (pixels == null) {
            throw new IllegalArgumentException("No Pixels specified.");
        }
        if (channels == null || channels.size() == 0) {
            throw new IllegalArgumentException("No channels specified.");
        }
        if (shapes == null || shapes.size() == 0) {
            throw new IllegalArgumentException("No shapes specified.");
        }
        this.pixels = pixels;
        this.channels = channels;
        Iterator i = shapes.iterator();
        ROIShape[] data = new ROIShape[shapes.size()];
        int index = 0;
        while (i.hasNext()) {
            data[index] = (ROIShape)i.next();
            ++index;
        }
        this.loadCall = this.analyseShapes(data);
    }
}

