/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;
import pojos.ExperimenterData;

public class AdminLoader
extends BatchCallTree {
    private Object result;
    private BatchCall loadCall;

    private BatchCall makeBatchCall() {
        return new BatchCall("Loading experimenter groups"){

            public void doCall() throws Exception {
                OmeroDataService os = AdminLoader.this.context.getDataService();
                AdminLoader.this.result = os.getAvailableGroups();
            }
        };
    }

    private BatchCall changePassword(final String oldPassword, final String newPassword) {
        return new BatchCall("Change password"){

            public void doCall() throws Exception {
                OmeroDataService os = AdminLoader.this.context.getDataService();
                AdminLoader.this.result = os.changePassword(oldPassword, newPassword);
            }
        };
    }

    private BatchCall updateExperimenter(final ExperimenterData exp) {
        return new BatchCall("Update experimenter"){

            public void doCall() throws Exception {
                OmeroDataService os = AdminLoader.this.context.getDataService();
                AdminLoader.this.result = os.updateExperimenter(exp);
            }
        };
    }

    protected void buildTree() {
        this.add(this.loadCall);
    }

    protected Object getResult() {
        return this.result;
    }

    public AdminLoader() {
        this.loadCall = this.makeBatchCall();
    }

    public AdminLoader(String oldPassword, String newPassword) {
        if (newPassword == null || newPassword.trim().length() == 0) {
            throw new IllegalArgumentException("Password not valid.");
        }
        if (oldPassword == null || oldPassword.trim().length() == 0) {
            throw new IllegalArgumentException("Password not valid.");
        }
        this.loadCall = this.changePassword(oldPassword, newPassword);
    }

    public AdminLoader(ExperimenterData exp) {
        if (exp == null) {
            throw new IllegalArgumentException("Experimenter not valid.");
        }
        this.loadCall = this.updateExperimenter(exp);
    }
}

