/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views;

import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.data.views.HierarchyBrowsingView;
import org.openmicroscopy.shoola.env.data.views.calls.ChannelMetadataLoader;
import org.openmicroscopy.shoola.env.data.views.calls.ClassificationLoader;
import org.openmicroscopy.shoola.env.data.views.calls.ClassificationSaver;
import org.openmicroscopy.shoola.env.data.views.calls.DataObjectSaver;
import org.openmicroscopy.shoola.env.data.views.calls.HierarchyFinder;
import org.openmicroscopy.shoola.env.data.views.calls.HierarchyLoader;
import org.openmicroscopy.shoola.env.data.views.calls.ImagesLoader;
import org.openmicroscopy.shoola.env.data.views.calls.ThumbnailLoader;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import pojos.CategoryGroupData;
import pojos.DataObject;
import pojos.ImageData;
import pojos.ProjectData;

class HierarchyBrowsingViewImpl
implements HierarchyBrowsingView {
    HierarchyBrowsingViewImpl() {
    }

    public CallHandle loadHierarchy(Class rootNodeType, Set nodesID, Class rootLevel, long rootID, AgentEventListener observer) {
        HierarchyLoader cmd = new HierarchyLoader(rootNodeType, nodesID, rootLevel, rootID);
        return cmd.exec(observer);
    }

    public CallHandle loadThumbnails(Set imgSummaries, int maxWidth, int maxHeight, AgentEventListener observer) {
        ThumbnailLoader cmd = new ThumbnailLoader(imgSummaries, maxWidth, maxHeight);
        return cmd.exec(observer);
    }

    public CallHandle findPDIHierarchies(Set ids, Class rootLevel, long rootID, AgentEventListener observer) {
        HierarchyFinder cmd = new HierarchyFinder(ProjectData.class, ids, rootLevel, rootID);
        return cmd.exec(observer);
    }

    public CallHandle findCGCIHierarchies(Set ids, Class rootLevel, long rootID, AgentEventListener observer) {
        HierarchyFinder cmd = new HierarchyFinder(CategoryGroupData.class, ids, rootLevel, rootID);
        return cmd.exec(observer);
    }

    public CallHandle loadClassificationPaths(Set imageIDs, int algorithm, Class rootLevel, long rootLevelID, AgentEventListener observer) {
        ClassificationLoader cmd = new ClassificationLoader(imageIDs, algorithm, rootLevel, rootLevelID);
        return cmd.exec(observer);
    }

    public CallHandle classify(Set images, Set categories, AgentEventListener observer) {
        ClassificationSaver cmd = new ClassificationSaver(images, categories, true);
        return cmd.exec(observer);
    }

    public CallHandle declassify(Set images, Set categories, AgentEventListener observer) {
        ClassificationSaver cmd = new ClassificationSaver(images, categories, false);
        return cmd.exec(observer);
    }

    public CallHandle loadImages(Set imageIDs, Class rootLevel, long rootLevelID, AgentEventListener observer) {
        ImagesLoader cmd = new ImagesLoader(ImageData.class, imageIDs, rootLevel, rootLevelID);
        return cmd.exec(observer);
    }

    public CallHandle updateDataObject(DataObject userObject, AgentEventListener observer) {
        DataObjectSaver cmd = new DataObjectSaver(userObject, null, 1);
        return cmd.exec(observer);
    }

    public CallHandle loadChannelsData(long pixelsID, AgentEventListener observer) {
        ChannelMetadataLoader cmd = new ChannelMetadataLoader(pixelsID);
        return cmd.exec(observer);
    }

    public CallHandle removeDataObjects(Set userObjects, DataObject parent, AgentEventListener observer) {
        DataObjectSaver cmd = new DataObjectSaver(userObjects, parent, 2);
        return cmd.exec(observer);
    }

    public CallHandle removeDataObjects(Map objects, AgentEventListener observer) {
        DataObjectSaver cmd = new DataObjectSaver(objects, 2);
        return cmd.exec(observer);
    }
}

