/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views;

import org.openmicroscopy.shoola.env.Container;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.views.DataHandlerView;
import org.openmicroscopy.shoola.env.data.views.DataHandlerViewImpl;
import org.openmicroscopy.shoola.env.data.views.DataManagerView;
import org.openmicroscopy.shoola.env.data.views.DataManagerViewImpl;
import org.openmicroscopy.shoola.env.data.views.DataServicesView;
import org.openmicroscopy.shoola.env.data.views.HierarchyBrowsingView;
import org.openmicroscopy.shoola.env.data.views.HierarchyBrowsingViewImpl;
import org.openmicroscopy.shoola.env.data.views.ImageDataView;
import org.openmicroscopy.shoola.env.data.views.ImageDataViewImpl;

public class DataViewsFactory {
    private static Registry context;

    static Registry getContext() {
        return context;
    }

    public static void initialize(Container c) {
        if (c == null) {
            throw new NullPointerException();
        }
        context = c.getRegistry();
    }

    public static DataServicesView makeView(Class view) {
        if (view == null) {
            throw new NullPointerException("No view specified.");
        }
        DataServicesView dsv = null;
        if (view.equals(HierarchyBrowsingView.class)) {
            dsv = new HierarchyBrowsingViewImpl();
        } else if (view.equals(DataManagerView.class)) {
            dsv = new DataManagerViewImpl();
        } else if (view.equals(ImageDataView.class)) {
            dsv = new ImageDataViewImpl();
        } else if (view.equals(DataHandlerView.class)) {
            dsv = new DataHandlerViewImpl();
        }
        if (dsv == null) {
            throw new IllegalArgumentException("Unknown view type: " + view + ".");
        }
        return dsv;
    }
}

