/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.data.views.DataManagerView;
import org.openmicroscopy.shoola.env.data.views.calls.AdminLoader;
import org.openmicroscopy.shoola.env.data.views.calls.ChannelMetadataLoader;
import org.openmicroscopy.shoola.env.data.views.calls.ClassificationLoader;
import org.openmicroscopy.shoola.env.data.views.calls.ClassificationSaver;
import org.openmicroscopy.shoola.env.data.views.calls.ContainerCounterLoader;
import org.openmicroscopy.shoola.env.data.views.calls.DMLoader;
import org.openmicroscopy.shoola.env.data.views.calls.DMRefreshLoader;
import org.openmicroscopy.shoola.env.data.views.calls.DataObjectSaver;
import org.openmicroscopy.shoola.env.data.views.calls.ExistingObjectsLoader;
import org.openmicroscopy.shoola.env.data.views.calls.ExistingObjectsSaver;
import org.openmicroscopy.shoola.env.data.views.calls.ImagesLoader;
import org.openmicroscopy.shoola.env.data.views.calls.ThumbnailLoader;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import pojos.DataObject;
import pojos.ExperimenterData;
import pojos.ImageData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataManagerViewImpl
implements DataManagerView {
    DataManagerViewImpl() {
    }

    @Override
    public CallHandle loadContainerHierarchy(Class rootNodeType, Set<Long> rootNodeIDs, boolean withLeaves, Class rootLevel, long rootLevelID, AgentEventListener observer) {
        DMLoader cmd = new DMLoader(rootNodeType, rootNodeIDs, withLeaves, rootLevel, rootLevelID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadImages(long userID, AgentEventListener observer) {
        ImagesLoader cmd = new ImagesLoader(userID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle getImages(Class nodeType, Set nodeIDs, Class rootLevel, long rootLevelID, AgentEventListener observer) {
        ImagesLoader cmd = new ImagesLoader(nodeType, nodeIDs, rootLevel, rootLevelID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle createDataObject(DataObject userObject, DataObject parent, AgentEventListener observer) {
        DataObjectSaver cmd = new DataObjectSaver(userObject, parent, 0);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle updateDataObject(DataObject userObject, AgentEventListener observer) {
        DataObjectSaver cmd = new DataObjectSaver(userObject, null, 1);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle removeDataObjects(Set userObjects, DataObject parent, AgentEventListener observer) {
        DataObjectSaver cmd = new DataObjectSaver(userObjects, parent, 2);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle removeDataObjects(Map objects, AgentEventListener observer) {
        DataObjectSaver cmd = new DataObjectSaver(objects, 2);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle countContainerItems(Set rootIDs, AgentEventListener observer) {
        ContainerCounterLoader cmd = new ContainerCounterLoader(rootIDs);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadThumbnail(ImageData image, int maxWidth, int maxHeight, AgentEventListener observer) {
        ThumbnailLoader cmd = new ThumbnailLoader(image, maxWidth, maxHeight);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadClassificationPaths(Set imageIDs, int algorithm, Class rootLevel, long rootLevelID, AgentEventListener observer) {
        ClassificationLoader cmd = new ClassificationLoader(imageIDs, algorithm, rootLevel, rootLevelID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle classify(Set images, Set categories, AgentEventListener observer) {
        ClassificationSaver cmd = new ClassificationSaver(images, categories, true);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle declassify(Set images, Set categories, AgentEventListener observer) {
        ClassificationSaver cmd = new ClassificationSaver(images, categories, false);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadExistingObjects(Class nodeType, Set nodeIDs, Class rootLevel, long rootLevelID, AgentEventListener observer) {
        ExistingObjectsLoader cmd = new ExistingObjectsLoader(nodeType, nodeIDs, rootLevel, rootLevelID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle addExistingObjects(DataObject parent, Set children, AgentEventListener observer) {
        ExistingObjectsSaver cmd = new ExistingObjectsSaver(parent, children);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle addExistingObjects(Map toPaste, AgentEventListener observer) {
        ExistingObjectsSaver cmd = new ExistingObjectsSaver(toPaste, null);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle refreshHierarchy(Class rootNodeType, List containerWithImages, Class rootLevel, long rootLevelID, AgentEventListener observer) {
        DMRefreshLoader cmd = new DMRefreshLoader(rootNodeType, containerWithImages, rootLevel, rootLevelID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle cutAndPaste(Map toPaste, Map toCut, AgentEventListener observer) {
        ExistingObjectsSaver cmd = new ExistingObjectsSaver(toPaste, toCut);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadChannelsData(long pixelsID, AgentEventListener observer) {
        ChannelMetadataLoader cmd = new ChannelMetadataLoader(pixelsID);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle loadAvailableGroups(AgentEventListener observer) {
        AdminLoader cmd = new AdminLoader();
        return cmd.exec(observer);
    }

    @Override
    public CallHandle changePassword(String oldPassword, String newPassword, AgentEventListener observer) {
        AdminLoader cmd = new AdminLoader(oldPassword, newPassword);
        return cmd.exec(observer);
    }

    @Override
    public CallHandle updateExperimenter(ExperimenterData exp, AgentEventListener observer) {
        AdminLoader cmd = new AdminLoader(exp);
        return cmd.exec(observer);
    }
}

