/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import ome.model.IObject;
import ome.model.annotations.DatasetAnnotation;
import ome.model.annotations.ImageAnnotation;
import ome.model.containers.Category;
import ome.model.containers.CategoryGroup;
import ome.model.containers.Dataset;
import ome.model.containers.Project;
import ome.model.core.Image;
import ome.model.core.Pixels;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import pojos.AnnotationData;
import pojos.CategoryData;
import pojos.CategoryGroupData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.GroupData;
import pojos.ImageData;
import pojos.PixelsData;
import pojos.ProjectData;

public class PojoMapper {
    private static Object convert(Object value) {
        if (value instanceof IObject) {
            return PojoMapper.asDataObject((IObject)value);
        }
        if (value instanceof Set) {
            return PojoMapper.asDataObjects((Set)value);
        }
        if (value instanceof Map) {
            return PojoMapper.asDataObjects((Map)value);
        }
        return null;
    }

    public static DataObject asDataObject(IObject object) {
        if (object == null) {
            throw new IllegalArgumentException("IObject cannot be null.");
        }
        if (object instanceof Project) {
            return new ProjectData((Project)object);
        }
        if (object instanceof Dataset) {
            return new DatasetData((Dataset)object);
        }
        if (object instanceof CategoryGroup) {
            return new CategoryGroupData((CategoryGroup)object);
        }
        if (object instanceof Category) {
            return new CategoryData((Category)object);
        }
        if (object instanceof Image) {
            return new ImageData((Image)object);
        }
        if (object instanceof ImageAnnotation) {
            return new AnnotationData((ImageAnnotation)object);
        }
        if (object instanceof DatasetAnnotation) {
            return new AnnotationData((DatasetAnnotation)object);
        }
        if (object instanceof Pixels) {
            return new PixelsData((Pixels)object);
        }
        if (object instanceof Experimenter) {
            return new ExperimenterData((Experimenter)object);
        }
        if (object instanceof ExperimenterGroup) {
            return new GroupData((ExperimenterGroup)object);
        }
        throw new IllegalArgumentException("Unknown IObject type: " + object.getClass().getName());
    }

    public static Set asDataObjects(Set objects) {
        if (objects == null) {
            throw new IllegalArgumentException("The set cannot be null.");
        }
        HashSet<DataObject> set = new HashSet<DataObject>(objects.size());
        Iterator i = objects.iterator();
        while (i.hasNext()) {
            set.add(PojoMapper.asDataObject((IObject)i.next()));
        }
        return set;
    }

    public static Set asDataObjects(IObject[] objects) {
        if (objects == null) {
            throw new IllegalArgumentException("The array cannot be null.");
        }
        HashSet<DataObject> set = new HashSet<DataObject>(objects.length);
        for (int i = 0; i < objects.length; ++i) {
            set.add(PojoMapper.asDataObject(objects[i]));
        }
        return set;
    }

    public static Map asDataObjects(Map objects) {
        if (objects == null) {
            throw new IllegalArgumentException("The map cannot be null.");
        }
        HashMap map = new HashMap(objects.size());
        Iterator i = objects.keySet().iterator();
        Object convertedKey = null;
        Object convertedValue = null;
        while (i.hasNext()) {
            Object key = i.next();
            Object value = objects.get(key);
            convertedKey = PojoMapper.convert(key);
            convertedValue = PojoMapper.convert(value);
            map.put(convertedKey == null ? key : convertedKey, convertedValue == null ? value : convertedValue);
        }
        return map;
    }
}

