/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.model.ILink;
import ome.model.IObject;
import ome.model.annotations.DatasetAnnotation;
import ome.model.annotations.ImageAnnotation;
import ome.model.containers.Category;
import ome.model.containers.CategoryGroup;
import ome.model.containers.CategoryGroupCategoryLink;
import ome.model.containers.CategoryImageLink;
import ome.model.containers.Dataset;
import ome.model.containers.DatasetImageLink;
import ome.model.containers.Project;
import ome.model.containers.ProjectDatasetLink;
import ome.model.core.Image;
import ome.model.meta.Experimenter;
import ome.util.Filter;
import ome.util.Filterable;
import pojos.AnnotationData;
import pojos.CategoryData;
import pojos.CategoryGroupData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ImageData;
import pojos.ProjectData;

public class ModelMapper {
    private static Filter unloader = new CollectionUnloader();

    public static void unloadCollections(IObject object) {
        if (object == null) {
            throw new IllegalArgumentException("The object mustn't be null.");
        }
        object.acceptFilter(unloader);
    }

    public static IObject unlinkChildFromParent(IObject child, IObject parent) {
        if (parent instanceof Dataset) {
            if (!(child instanceof Image)) {
                throw new IllegalArgumentException("Child not valid.");
            }
            List links = ((Image)child).collectDatasetLinks(null);
            Iterator i = links.iterator();
            DatasetImageLink link = null;
            while (i.hasNext() && (link = (DatasetImageLink)i.next()).getParent().getId().longValue() != parent.getId().longValue()) {
            }
            return link;
        }
        if (parent instanceof Category) {
            if (!(child instanceof Image)) {
                throw new IllegalArgumentException("Child not valid.");
            }
            List links = ((Image)child).collectCategoryLinks(null);
            Iterator i = links.iterator();
            CategoryImageLink link = null;
            while (i.hasNext() && (link = (CategoryImageLink)i.next()).getParent().getId().longValue() != parent.getId().longValue()) {
            }
            return link;
        }
        if (parent instanceof Project) {
            if (!(child instanceof Dataset)) {
                throw new IllegalArgumentException("Child not valid.");
            }
            List links = ((Project)parent).collectDatasetLinks(null);
            Iterator i = links.iterator();
            ProjectDatasetLink link = null;
            long childID = child.getId();
            while (i.hasNext()) {
                link = (ProjectDatasetLink)i.next();
                if (link.getChild().getId() != childID) continue;
                return link;
            }
        } else if (parent instanceof CategoryGroup) {
            if (!(child instanceof Category)) {
                throw new IllegalArgumentException("Child not valid.");
            }
            List links = ((CategoryGroup)parent).collectCategoryLinks(null);
            Iterator i = links.iterator();
            CategoryGroupCategoryLink link = null;
            while (i.hasNext() && (link = (CategoryGroupCategoryLink)i.next()).getParent().getId().longValue() != parent.getId().longValue()) {
            }
            return link;
        }
        throw new IllegalArgumentException("Parent not supported.");
    }

    public static ILink linkParentToChild(IObject child, IObject parent) {
        if (parent == null) {
            return null;
        }
        if (child == null) {
            throw new IllegalArgumentException("Child cannotbe null.");
        }
        if (parent instanceof Project) {
            if (!(child instanceof Dataset)) {
                throw new IllegalArgumentException("Child not valid.");
            }
            Project unloadedProject = new Project(parent.getId(), false);
            Dataset unloadedDataset = new Dataset(child.getId(), false);
            ProjectDatasetLink l = new ProjectDatasetLink();
            l.link(unloadedProject, unloadedDataset);
            return l;
        }
        if (parent instanceof CategoryGroup) {
            if (!(child instanceof Category)) {
                throw new IllegalArgumentException("Child not valid.");
            }
            CategoryGroup unloadedGroup = new CategoryGroup(parent.getId(), false);
            Category unloadedCategory = new Category(child.getId(), false);
            CategoryGroupCategoryLink l = new CategoryGroupCategoryLink();
            l.link(unloadedGroup, unloadedCategory);
            return l;
        }
        if (parent instanceof Dataset) {
            if (!(child instanceof Image)) {
                throw new IllegalArgumentException("Child not valid.");
            }
            Dataset unloadedDataset = new Dataset(parent.getId(), false);
            Image unloadedImage = new Image(child.getId(), false);
            DatasetImageLink l = new DatasetImageLink();
            l.link(unloadedDataset, unloadedImage);
            return l;
        }
        if (parent instanceof Dataset) {
            if (!(child instanceof Image)) {
                throw new IllegalArgumentException("Child not valid.");
            }
            Dataset unloadedDataset = new Dataset(parent.getId(), false);
            Image unloadedImage = new Image(child.getId(), false);
            DatasetImageLink l = new DatasetImageLink();
            l.link(unloadedDataset, unloadedImage);
            return l;
        }
        if (parent instanceof Category) {
            if (!(child instanceof Image)) {
                throw new IllegalArgumentException("Child not valid.");
            }
            Category unloadedCategory = new Category(parent.getId(), false);
            Image unloadedImage = new Image(child.getId(), false);
            CategoryImageLink l = new CategoryImageLink();
            l.link(unloadedCategory, unloadedImage);
            return l;
        }
        return null;
    }

    public static void linkParentToNewChild(IObject child, IObject parent) {
        if (parent == null) {
            return;
        }
        if (child == null) {
            throw new IllegalArgumentException("Child cannotbe null.");
        }
        if (parent instanceof Project) {
            if (!(child instanceof Dataset)) {
                throw new IllegalArgumentException("Child not valid.");
            }
            Project p = (Project)parent;
            Dataset d = (Dataset)child;
            Iterator it = d.iterateProjectLinks();
            while (it.hasNext()) {
                ProjectDatasetLink link = (ProjectDatasetLink)it.next();
                if (!p.getId().equals(link.parent().getId())) continue;
                p.addProjectDatasetLink(link, false);
            }
        } else if (parent instanceof CategoryGroup) {
            if (!(child instanceof Category)) {
                throw new IllegalArgumentException("Child not valid.");
            }
            CategoryGroup p = (CategoryGroup)parent;
            Category d = (Category)child;
            Iterator it = d.iterateCategoryGroupLinks();
            while (it.hasNext()) {
                CategoryGroupCategoryLink link = (CategoryGroupCategoryLink)it.next();
                if (!p.getId().equals(link.parent().getId())) continue;
                p.addCategoryGroupCategoryLink(link, false);
            }
        } else if (parent instanceof Dataset) {
            if (!(child instanceof Image)) {
                throw new IllegalArgumentException("Child not valid.");
            }
            Dataset p = (Dataset)parent;
            Image d = (Image)child;
            Iterator it = d.iterateDatasetLinks();
            while (it.hasNext()) {
                DatasetImageLink link = (DatasetImageLink)it.next();
                if (!p.getId().equals(link.parent().getId())) continue;
                p.addDatasetImageLink(link, false);
            }
        } else if (parent instanceof Category) {
            if (!(child instanceof Image)) {
                throw new IllegalArgumentException("Child not valid.");
            }
            Category p = (Category)parent;
            Image d = (Image)child;
            Iterator it = d.iterateCategoryLinks();
            while (it.hasNext()) {
                CategoryImageLink link = (CategoryImageLink)it.next();
                if (!p.getId().equals(link.parent().getId())) continue;
                p.addCategoryImageLink(link, false);
            }
        } else {
            throw new IllegalArgumentException("DataObject not supported.");
        }
    }

    public static IObject createIObject(DataObject child, DataObject parent) {
        if (child instanceof ProjectData) {
            ProjectData data = (ProjectData)child;
            Project model = new Project();
            model.setName(data.getName());
            model.setDescription(data.getDescription());
            return model;
        }
        if (child instanceof CategoryGroupData) {
            CategoryGroupData data = (CategoryGroupData)child;
            CategoryGroup model = new CategoryGroup();
            model.setName(data.getName());
            model.setDescription(data.getDescription());
            return model;
        }
        if (child instanceof DatasetData) {
            if (!(parent instanceof ProjectData)) {
                throw new IllegalArgumentException("Parent not valid.");
            }
            DatasetData data = (DatasetData)child;
            Dataset model = new Dataset();
            model.setName(data.getName());
            model.setDescription(data.getDescription());
            model.linkProject(new Project(new Long(parent.getId()), false));
            return model;
        }
        if (child instanceof CategoryData) {
            if (!(parent instanceof CategoryGroupData)) {
                throw new IllegalArgumentException("Parent not valid.");
            }
            CategoryData data = (CategoryData)child;
            Category model = new Category();
            model.setName(data.getName());
            model.setDescription(data.getDescription());
            model.linkCategoryGroup(new CategoryGroup(new Long(parent.getId()), false));
            return model;
        }
        if (child instanceof ImageData) {
            if (!(parent instanceof CategoryData) && !(parent instanceof DatasetData)) {
                throw new IllegalArgumentException("Parent not valid.");
            }
            ImageData data = (ImageData)child;
            Image model = new Image();
            model.setName(data.getName());
            model.setDescription(data.getDescription());
            if (parent instanceof CategoryData) {
                model.linkCategory(new Category(new Long(parent.getId()), false));
            } else if (parent instanceof DatasetData) {
                model.linkDataset(new Dataset(new Long(parent.getId()), false));
            }
            return model;
        }
        throw new IllegalArgumentException("Child and parent are not compatible.");
    }

    public static IObject removeIObject(IObject child, IObject parent) {
        if (child instanceof Dataset && parent instanceof Project) {
            Dataset mChild = (Dataset)child;
            Project mParent = (Project)parent;
            Set s = mParent.findProjectDatasetLink(mChild);
            Iterator i = s.iterator();
            while (i.hasNext()) {
                mParent.removeProjectDatasetLink((ProjectDatasetLink)i.next(), false);
            }
            return mParent;
        }
        if (child instanceof Category && parent instanceof CategoryGroup) {
            Category mChild = (Category)child;
            CategoryGroup mParent = (CategoryGroup)parent;
            Set s = mParent.findCategoryGroupCategoryLink(mChild);
            Iterator i = s.iterator();
            while (i.hasNext()) {
                mParent.removeCategoryGroupCategoryLink((CategoryGroupCategoryLink)i.next(), false);
            }
            return mParent;
        }
        throw new IllegalArgumentException("DataObject not supported.");
    }

    public static IObject createAnnotation(IObject annotatedObject, AnnotationData data) {
        if (annotatedObject instanceof Dataset) {
            Dataset m = (Dataset)annotatedObject;
            DatasetAnnotation annotation = new DatasetAnnotation();
            annotation.setContent(data.getText());
            annotation.setDataset(m);
            return annotation;
        }
        if (annotatedObject instanceof Image) {
            Image m = (Image)annotatedObject;
            ImageAnnotation annotation = new ImageAnnotation();
            annotation.setContent(data.getText());
            annotation.setImage(m);
            return annotation;
        }
        throw new IllegalArgumentException("DataObject cannot be annotated.");
    }

    public static void setAnnotatedObject(IObject annotated, IObject annotation) {
        if (annotation instanceof ImageAnnotation) {
            ((ImageAnnotation)annotation).setImage((Image)annotated);
        }
        if (annotation instanceof DatasetAnnotation) {
            ((DatasetAnnotation)annotation).setDataset((Dataset)annotated);
        }
    }

    public static IObject getAnnotatedObject(IObject annotation) {
        if (annotation instanceof ImageAnnotation) {
            return ((ImageAnnotation)annotation).getImage();
        }
        if (annotation instanceof DatasetAnnotation) {
            return ((DatasetAnnotation)annotation).getDataset();
        }
        throw new IllegalArgumentException("Annotation can only be DatasetAnnoation or ImageAnnotation.");
    }

    public static void fillIObject(IObject oldObject, IObject newObject) {
        if (oldObject == null || newObject == null) {
            throw new IllegalArgumentException("Object cannot be NULL.");
        }
        if (oldObject.getClass() != newObject.getClass()) {
            throw new IllegalArgumentException("Objects should be of the same type.");
        }
        if (oldObject instanceof Project) {
            Project n = (Project)newObject;
            Project o = (Project)oldObject;
            n.setName(o.getName());
            n.setDescription(o.getDescription());
        } else if (oldObject instanceof Dataset) {
            Dataset n = (Dataset)newObject;
            Dataset o = (Dataset)oldObject;
            n.setName(o.getName());
            n.setDescription(o.getDescription());
        } else if (oldObject instanceof Image) {
            Image n = (Image)newObject;
            Image o = (Image)oldObject;
            n.setName(o.getName());
            n.setDescription(o.getDescription());
        } else if (oldObject instanceof CategoryGroup) {
            CategoryGroup n = (CategoryGroup)newObject;
            CategoryGroup o = (CategoryGroup)oldObject;
            n.setName(o.getName());
            n.setDescription(o.getDescription());
        } else if (oldObject instanceof Category) {
            Category n = (Category)newObject;
            Category o = (Category)oldObject;
            n.setName(o.getName());
            n.setDescription(o.getDescription());
        } else if (oldObject instanceof ImageAnnotation) {
            ImageAnnotation n = (ImageAnnotation)newObject;
            ImageAnnotation o = (ImageAnnotation)oldObject;
            n.setContent(o.getContent());
            n.setImage(o.getImage());
        } else if (oldObject instanceof DatasetAnnotation) {
            DatasetAnnotation n = (DatasetAnnotation)newObject;
            DatasetAnnotation o = (DatasetAnnotation)oldObject;
            n.setContent(o.getContent());
            n.setDataset(o.getDataset());
        } else if (oldObject instanceof Experimenter) {
            Experimenter n = (Experimenter)newObject;
            Experimenter o = (Experimenter)oldObject;
            n.setEmail(o.getEmail());
            n.setFirstName(o.getFirstName());
            n.setLastName(o.getLastName());
            n.setInstitution(o.getInstitution());
        }
    }

    private static class CollectionUnloader
    implements Filter {
        private CollectionUnloader() {
        }

        public Filterable filter(String arg0, Filterable arg1) {
            return arg1;
        }

        public Collection filter(String arg0, Collection arg1) {
            return null;
        }

        public Map filter(String arg0, Map arg1) {
            return arg1;
        }

        public Object filter(String arg0, Object arg1) {
            return arg1;
        }
    }
}

