/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.model;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.openmicroscopy.shoola.env.data.model.DataObject;

public class ThumbnailData
implements DataObject {
    private long imageID;
    private BufferedImage thumbnail;

    public ThumbnailData(long imageID, BufferedImage thumbnail) {
        if (imageID <= 0L) {
            throw new IllegalArgumentException("Non-positive image id: " + imageID + ".");
        }
        if (thumbnail == null) {
            throw new NullPointerException("No thumbnail.");
        }
        this.imageID = imageID;
        this.thumbnail = thumbnail;
    }

    public DataObject makeNew() {
        BufferedImage pixClone = new BufferedImage(this.thumbnail.getWidth(), this.thumbnail.getHeight(), this.thumbnail.getType());
        Graphics2D g2D = pixClone.createGraphics();
        g2D.drawImage(this.thumbnail, null, 0, 0);
        return new ThumbnailData(this.imageID, pixClone);
    }

    public long getImageID() {
        return this.imageID;
    }

    public BufferedImage getThumbnail() {
        return this.thumbnail;
    }
}

