/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.model;

public class ChannelMetadata {
    private final int index;
    private int emissionWavelength;
    private int excitationWavelength;
    private int pinHoleSize;
    private float ndFilter;
    private double globalMin;
    private double globalMax;

    void setEmissionWavelength(int emissionWavelength) {
        this.emissionWavelength = emissionWavelength;
    }

    void setExcitationWavelength(int excitationWavelength) {
        this.excitationWavelength = excitationWavelength;
    }

    void setPinHoleSize(int pinHoleSize) {
        this.pinHoleSize = pinHoleSize;
    }

    void setNDFilter(float ndFilter) {
        this.ndFilter = ndFilter;
    }

    public ChannelMetadata(int index, double globalMin, double globalMax) {
        if (index < 0) {
            throw new IllegalArgumentException("Channel index cannot < 0.");
        }
        if (globalMin > globalMax) {
            throw new IllegalArgumentException("Min cannot less than Max");
        }
        this.index = index;
        this.globalMin = globalMin;
        this.globalMax = globalMax;
        this.emissionWavelength = index;
        this.excitationWavelength = -1;
    }

    public int getEmissionWavelength() {
        return this.emissionWavelength;
    }

    public int getExcitationWavelength() {
        if (this.excitationWavelength < 0) {
            return this.getEmissionWavelength();
        }
        return this.excitationWavelength;
    }

    public int getPinholeSize() {
        return this.pinHoleSize;
    }

    public float getNDFilter() {
        return this.ndFilter;
    }

    public double getGlobalMin() {
        return this.globalMin;
    }

    public double getGlobalMax() {
        return this.globalMax;
    }

    public int getIndex() {
        return this.index;
    }
}

