/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.login;

import org.openmicroscopy.shoola.env.Container;
import org.openmicroscopy.shoola.env.data.DSOutOfServiceException;
import org.openmicroscopy.shoola.env.data.DataServicesFactory;
import org.openmicroscopy.shoola.env.data.events.ServiceActivationRequest;
import org.openmicroscopy.shoola.env.data.events.ServiceActivationResponse;
import org.openmicroscopy.shoola.env.data.login.LoginConfig;
import org.openmicroscopy.shoola.env.data.login.LoginService;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.event.AgentEvent;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.log.LogMessage;
import org.openmicroscopy.shoola.env.log.Logger;
import org.openmicroscopy.shoola.env.ui.UserNotifier;

public class LoginServiceImpl
implements LoginService {
    private int state;
    private Container container;
    protected LoginConfig config;

    private void pause() {
        try {
            Thread.sleep(this.config.getRetryInterval());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean attempt() {
        UserCredentials uc = this.config.getCredentials();
        try {
            if (uc == null) {
                throw new DSOutOfServiceException("No user's credentials have been entered yet.");
            }
            DataServicesFactory factory = DataServicesFactory.getInstance(this.container);
            if (factory.isConnected()) {
                return true;
            }
            factory.connect(uc);
            LogMessage msg = new LogMessage();
            msg.println("Logged onto OMERO at: " + uc.getHostName());
            msg.println(uc);
            Logger logger = this.container.getRegistry().getLogger();
            logger.info((Object)this, msg);
            return true;
        }
        catch (DSOutOfServiceException dsose) {
            LogMessage msg = new LogMessage();
            msg.println("Failed to log onto OMERO.");
            msg.println("Reason: " + dsose.getMessage());
            msg.println("OMERO address: " + uc.getHostName());
            if (uc != null) {
                msg.println(uc);
            }
            Logger logger = this.container.getRegistry().getLogger();
            logger.error((Object)this, msg);
            return false;
        }
    }

    protected void askForCredentials() {
    }

    public LoginServiceImpl(Container c) {
        if (c == null) {
            throw new NullPointerException("No container.");
        }
        this.config = new LoginConfig(c.getRegistry());
        this.container = c;
        EventBus bus = c.getRegistry().getEventBus();
        bus.register((AgentEventListener)this, ServiceActivationRequest.class);
        this.state = 0;
    }

    public int getState() {
        return this.state;
    }

    public void login() {
        this.state = 1;
        int max = this.config.getMaxRetry();
        while (0 < max--) {
            if (this.attempt()) {
                this.state = 0;
                return;
            }
            this.pause();
        }
        this.askForCredentials();
    }

    public boolean login(UserCredentials uc) {
        this.state = 1;
        this.config.setCredentials(uc);
        boolean succeeded = this.attempt();
        if (!succeeded) {
            UserNotifier un = this.container.getRegistry().getUserNotifier();
            un.notifyError("Login Failure", "Failed to log onto OMERO.\nPlease check your user name\nand/or password or try again later.");
        }
        this.state = 0;
        return succeeded;
    }

    public void eventFired(AgentEvent ae) {
        ServiceActivationRequest sar = (ServiceActivationRequest)ae;
        boolean connected = false;
        try {
            DataServicesFactory factory = DataServicesFactory.getInstance(this.container);
            connected = factory.isConnected();
        }
        catch (DSOutOfServiceException dsose) {
            // empty catch block
        }
        ServiceActivationResponse resp = new ServiceActivationResponse(sar, connected);
        EventBus bus = this.container.getRegistry().getEventBus();
        bus.post(resp);
    }
}

