/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.login;

import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;

public class LoginConfig {
    public static final int DEFAULT_MAX_RETRY = 3;
    public static final int DEFAULT_RETRY_INTERVAL = 500;
    private UserCredentials credentials;
    private int maxRetry;
    private int retryInterval;

    private void readConfig(Registry reg) {
        Integer x = (Integer)reg.lookup("/services/LOGIN/omeds/max-retry");
        this.maxRetry = x == null ? -1 : x;
        x = (Integer)reg.lookup("/services/LOGIN/omeds/retry-interval");
        this.retryInterval = x == null ? -1 : x;
    }

    void setCredentials(UserCredentials uc) {
        this.credentials = uc;
    }

    public LoginConfig(Registry reg) {
        if (reg == null) {
            throw new NullPointerException("No registry.");
        }
        this.readConfig(reg);
        if (this.maxRetry <= 0) {
            this.maxRetry = 3;
        }
        if (this.retryInterval <= 0) {
            this.retryInterval = 500;
        }
    }

    public UserCredentials getCredentials() {
        return this.credentials;
    }

    public int getMaxRetry() {
        return this.maxRetry;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }
}

