/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.util.List;
import javax.imageio.ImageIO;
import ome.model.core.Pixels;
import ome.model.core.PixelsDimensions;
import omeis.providers.re.RenderingEngine;
import omeis.providers.re.data.PlaneDef;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.DSAccessException;
import org.openmicroscopy.shoola.env.data.DSOutOfServiceException;
import org.openmicroscopy.shoola.env.data.OMEROGateway;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.rnd.PixelsServicesFactory;
import org.openmicroscopy.shoola.env.rnd.RenderingControl;
import org.openmicroscopy.shoola.env.rnd.RenderingServiceException;

class OmeroImageServiceImpl
implements OmeroImageService {
    private Registry context;
    private OMEROGateway gateway;

    private BufferedImage createImage(byte[] values) throws RenderingServiceException {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(values);
            return ImageIO.read(stream);
        }
        catch (Exception e) {
            throw new RenderingServiceException("Cannot create buffered image", e);
        }
    }

    OmeroImageServiceImpl(OMEROGateway gateway, Registry registry) {
        if (registry == null) {
            throw new IllegalArgumentException("No registry.");
        }
        if (gateway == null) {
            throw new IllegalArgumentException("No gateway.");
        }
        this.context = registry;
        this.gateway = gateway;
    }

    void shutDown() {
        PixelsServicesFactory.shutDownRenderingControls(this.context);
    }

    public RenderingControl loadRenderingControl(long pixelsID) throws DSOutOfServiceException, DSAccessException {
        RenderingControl proxy = PixelsServicesFactory.getRenderingControl(this.context, new Long(pixelsID));
        if (proxy == null) {
            RenderingEngine re = this.gateway.createRenderingEngine(pixelsID);
            PixelsDimensions pixDims = this.gateway.getPixelsDimensions(pixelsID);
            List l = this.context.getDataService().getChannelsMetadata(pixelsID);
            proxy = PixelsServicesFactory.createRenderingControl(this.context, re, pixDims, l);
        }
        return proxy;
    }

    public BufferedImage renderImage(long pixelsID, PlaneDef pDef) throws RenderingServiceException {
        try {
            return PixelsServicesFactory.render(this.context, new Long(pixelsID), pDef);
        }
        catch (Exception e) {
            throw new RenderingServiceException("RenderImage", e);
        }
    }

    public BufferedImage renderImage(long pixelsID) throws RenderingServiceException {
        return this.renderImage(pixelsID, null);
    }

    public void shutDown(long pixelsID) {
        PixelsServicesFactory.shutDownRenderingControl(this.context, pixelsID);
    }

    public BufferedImage getThumbnail(long pixID, int sizeX, int sizeY) throws RenderingServiceException {
        try {
            return this.createImage(this.gateway.getThumbnail(pixID, sizeX, sizeY));
        }
        catch (Exception e) {
            if (e instanceof DSOutOfServiceException) {
                this.context.getLogger().error((Object)this, e.getMessage());
                return this.getThumbnail(pixID, sizeX, sizeY);
            }
            throw new RenderingServiceException("Get Thumbnail", e);
        }
    }

    public void reloadRenderingService(long pixelsID) throws RenderingServiceException {
        RenderingControl proxy = PixelsServicesFactory.getRenderingControl(this.context, new Long(pixelsID));
        if (proxy == null) {
            return;
        }
        try {
            PixelsServicesFactory.shutDownRenderingControl(this.context, pixelsID);
            RenderingEngine re = this.gateway.createRenderingEngine(pixelsID);
            PixelsServicesFactory.resetRenderingControl(this.context, pixelsID, re);
        }
        catch (Exception e) {
            throw new RenderingServiceException("Cannot restart the rendering engine for : " + pixelsID, e);
        }
    }

    public PixelsDimensions loadPixelsDimensions(long pixelsID) throws DSOutOfServiceException, DSAccessException {
        return this.gateway.getPixelsDimensions(pixelsID);
    }

    public Pixels loadPixels(long pixelsID) throws DSOutOfServiceException, DSAccessException {
        return this.gateway.getPixels(pixelsID);
    }

    public BufferedImage getThumbnailByLongestSide(long pixelsID, int maxLength) throws RenderingServiceException {
        try {
            return this.createImage(this.gateway.getThumbnailByLongestSide(pixelsID, maxLength));
        }
        catch (Exception e) {
            if (e instanceof DSOutOfServiceException) {
                this.context.getLogger().error((Object)this, e.getMessage());
                return this.getThumbnailByLongestSide(pixelsID, maxLength);
            }
            throw new RenderingServiceException("Get Thumbnail", e);
        }
    }

    public byte[] getPlane(long pixelsID, int z, int t, int c) throws DSOutOfServiceException, DSAccessException {
        return this.gateway.getPlane(pixelsID, z, t, c);
    }
}

