/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ome.model.ILink;
import ome.model.IObject;
import ome.model.core.Channel;
import ome.model.meta.Experimenter;
import ome.util.builders.PojoOptions;
import org.openmicroscopy.shoola.env.config.AgentInfo;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.DSAccessException;
import org.openmicroscopy.shoola.env.data.DSOutOfServiceException;
import org.openmicroscopy.shoola.env.data.OMEROGateway;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.data.model.ChannelMetadata;
import org.openmicroscopy.shoola.env.data.model.Mapper;
import org.openmicroscopy.shoola.env.data.util.ModelMapper;
import org.openmicroscopy.shoola.env.data.util.PojoMapper;
import pojos.AnnotationData;
import pojos.CategoryData;
import pojos.CategoryGroupData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.GroupData;
import pojos.ImageData;
import pojos.ProjectData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OmeroDataServiceImpl
implements OmeroDataService {
    private Registry context;
    private OMEROGateway gateway;

    private ExperimenterData getUserDetails() {
        return (ExperimenterData)this.context.lookup("/current_user/details");
    }

    private void setRootOptions(PojoOptions po, Class rootLevel, long rootID) {
        if (rootLevel.equals(GroupData.class)) {
            po.grp(new Long(rootID));
        } else if (rootLevel.equals(ExperimenterData.class)) {
            po.exp(new Long(rootID));
        }
    }

    private boolean checkAlgorithm(int algorithm) {
        switch (algorithm) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    private void cut(DataObject parent, Set children) throws DSOutOfServiceException, DSAccessException {
        IObject mParent = parent.asIObject();
        Iterator i = children.iterator();
        ArrayList<Long> ids = new ArrayList<Long>(children.size());
        while (i.hasNext()) {
            ids.add(new Long(((DataObject)i.next()).getId()));
        }
        List links = this.gateway.findLinks(mParent, ids);
        if (links != null) {
            this.gateway.deleteObjects(links.toArray(new IObject[links.size()]));
        }
    }

    OmeroDataServiceImpl(OMEROGateway gateway, Registry registry) {
        if (registry == null) {
            throw new IllegalArgumentException("No registry.");
        }
        if (gateway == null) {
            throw new IllegalArgumentException("No gateway.");
        }
        this.context = registry;
        this.gateway = gateway;
    }

    @Override
    public Set loadContainerHierarchy(Class rootNodeType, Set rootNodeIDs, boolean withLeaves, Class rootLevel, long rootLevelID) throws DSOutOfServiceException, DSAccessException {
        PojoOptions po = new PojoOptions();
        po.allCounts();
        this.setRootOptions(po, rootLevel, rootLevelID);
        if (withLeaves) {
            po.leaves();
        } else {
            po.noLeaves();
        }
        if (rootLevel.equals(GroupData.class)) {
            po.countsFor(new Long(this.getUserDetails().getId()));
        } else {
            po.countsFor(new Long(rootLevelID));
        }
        Set parents = this.gateway.loadContainerHierarchy(rootNodeType, rootNodeIDs, po.map());
        if (rootNodeIDs == null && parents != null) {
            Class<DatasetData> klass = null;
            if (rootNodeType.equals(ProjectData.class)) {
                klass = DatasetData.class;
            } else if (rootNodeType.equals(CategoryGroupData.class)) {
                klass = CategoryData.class;
            }
            if (klass != null) {
                PojoOptions options = new PojoOptions();
                this.setRootOptions(options, rootLevel, rootLevelID);
                options.noLeaves();
                Set r = this.gateway.loadContainerHierarchy(klass, null, options.map());
                Iterator i = parents.iterator();
                HashSet children = new HashSet();
                while (i.hasNext()) {
                    DataObject parent = (DataObject)i.next();
                    if (klass.equals(DatasetData.class)) {
                        children.addAll(((ProjectData)parent).getDatasets());
                        continue;
                    }
                    children.addAll(((CategoryGroupData)parent).getCategories());
                }
                HashSet<Long> childrenIds = new HashSet<Long>();
                for (DataObject child : children) {
                    childrenIds.add(new Long(child.getId()));
                }
                HashSet orphans = new HashSet();
                orphans.addAll(r);
                for (DataObject child : r) {
                    if (!childrenIds.contains(new Long(child.getId()))) continue;
                    orphans.remove(child);
                }
                if (orphans.size() > 0) {
                    parents.addAll(orphans);
                }
            }
        }
        return parents;
    }

    @Override
    public Set findContainerHierarchy(Class rootNodeType, Set leavesIDs, Class rootLevel, long rootLevelID) throws DSOutOfServiceException, DSAccessException {
        try {
            PojoOptions po = new PojoOptions();
            po.leaves();
            this.setRootOptions(po, rootLevel, rootLevelID);
            if (rootLevel.equals(GroupData.class)) {
                po.countsFor(new Long(this.getUserDetails().getId()));
            } else {
                po.countsFor(new Long(rootLevelID));
            }
            return this.gateway.findContainerHierarchy(rootNodeType, leavesIDs, po.map());
        }
        catch (Exception e) {
            throw new DSAccessException(e.getMessage());
        }
    }

    @Override
    public Map findAnnotations(Class nodeType, Set nodeIDs, Set annotatorIDs, boolean forUser) throws DSOutOfServiceException, DSAccessException {
        PojoOptions po = new PojoOptions();
        po.noCounts();
        po.noLeaves();
        if (forUser) {
            po.exp(new Long(this.getUserDetails().getId()));
        }
        return this.gateway.findAnnotations(nodeType, nodeIDs, annotatorIDs, new PojoOptions().map());
    }

    @Override
    public Set findCGCPaths(Set imgIDs, int algorithm, Class rootLevel, long rootLevelID) throws DSOutOfServiceException, DSAccessException {
        if (!this.checkAlgorithm(algorithm)) {
            throw new IllegalArgumentException("Find CGCPaths algorithm not supported.");
        }
        PojoOptions po = new PojoOptions();
        po.noCounts();
        po.exp(new Long(this.getUserDetails().getId()));
        return this.gateway.findCGCPaths(imgIDs, algorithm, po.map());
    }

    @Override
    public Set getImages(Class nodeType, Set nodeIDs, Class rootLevel, long rootLevelID) throws DSOutOfServiceException, DSAccessException {
        PojoOptions po = new PojoOptions();
        po.allCounts();
        this.setRootOptions(po, rootLevel, rootLevelID);
        if (rootLevel.equals(GroupData.class)) {
            po.countsFor(new Long(this.getUserDetails().getId()));
        } else {
            po.countsFor(new Long(rootLevelID));
        }
        return this.gateway.getContainerImages(nodeType, nodeIDs, po.map());
    }

    @Override
    public Set getExperimenterImages(long userID) throws DSOutOfServiceException, DSAccessException {
        PojoOptions po = new PojoOptions();
        po.noCounts();
        po.exp(new Long(userID));
        return this.gateway.getUserImages(po.map());
    }

    @Override
    public Map getCollectionCount(Class rootNodeType, String property, Set rootNodeIDs) throws DSOutOfServiceException, DSAccessException {
        PojoOptions po = new PojoOptions();
        po.noCounts();
        if (!property.equals("images")) {
            throw new IllegalArgumentException("Property not supported.");
        }
        Map m = this.gateway.getCollectionCount(rootNodeType, property, rootNodeIDs, po.map());
        return m;
    }

    @Override
    public DataObject createAnnotationFor(DataObject annotatedObject, AnnotationData data) throws DSOutOfServiceException, DSAccessException {
        if (data == null) {
            throw new IllegalArgumentException("No annotation to create.");
        }
        if (annotatedObject == null) {
            throw new IllegalArgumentException("No DataObject to annotate.");
        }
        if (!(annotatedObject instanceof ImageData) && !(annotatedObject instanceof DatasetData)) {
            throw new IllegalArgumentException("This method only supports ImageData and DatasetData objects.");
        }
        IObject ho = this.gateway.findIObject(annotatedObject.asIObject());
        if (ho == null) {
            return null;
        }
        IObject object = this.gateway.createObject(ModelMapper.createAnnotation(ho, data), new PojoOptions().map());
        return PojoMapper.asDataObject(ModelMapper.getAnnotatedObject(object));
    }

    @Override
    public DataObject removeAnnotationFrom(DataObject annotatedObject, AnnotationData data) throws DSOutOfServiceException, DSAccessException {
        if (data == null) {
            throw new IllegalArgumentException("No annotation to delete.");
        }
        if (annotatedObject == null) {
            throw new IllegalArgumentException("No annotated DataObject.");
        }
        if (!(annotatedObject instanceof ImageData) && !(annotatedObject instanceof DatasetData)) {
            throw new IllegalArgumentException("This method only supports ImageData and DatasetData objects.");
        }
        IObject ho = this.gateway.findIObject(data.asIObject());
        if (ho != null) {
            this.gateway.deleteObject(ho);
        }
        ho = this.gateway.findIObject(annotatedObject.asIObject());
        return PojoMapper.asDataObject(ho);
    }

    @Override
    public DataObject removeAnnotationFrom(DataObject annotatedObject, List data) throws DSOutOfServiceException, DSAccessException {
        IObject ho;
        if (data == null) {
            throw new IllegalArgumentException("No annotation to delete.");
        }
        if (annotatedObject == null) {
            throw new IllegalArgumentException("No annotated DataObject.");
        }
        if (!(annotatedObject instanceof ImageData) && !(annotatedObject instanceof DatasetData)) {
            throw new IllegalArgumentException("This method only supports ImageData and DatasetData objects.");
        }
        for (AnnotationData d : data) {
            ho = this.gateway.findIObject(d.asIObject());
            if (ho == null) continue;
            this.gateway.deleteObject(ho);
        }
        ho = this.gateway.findIObject(annotatedObject.asIObject());
        return PojoMapper.asDataObject(ho);
    }

    @Override
    public DataObject updateAnnotationFor(DataObject annotatedObject, AnnotationData data) throws DSOutOfServiceException, DSAccessException {
        if (data == null) {
            throw new IllegalArgumentException("No annotation to update.");
        }
        if (annotatedObject == null) {
            throw new IllegalArgumentException("No annotated DataObject.");
        }
        if (!(annotatedObject instanceof ImageData) && !(annotatedObject instanceof DatasetData)) {
            throw new IllegalArgumentException("This method only supports ImageData and DatasetData objects.");
        }
        Map options = new PojoOptions().map();
        IObject object = annotatedObject.asIObject();
        IObject ho = this.gateway.findIObject(object);
        if (ho == null) {
            return null;
        }
        ModelMapper.fillIObject(object, ho);
        ModelMapper.unloadCollections(ho);
        IObject updated = this.gateway.updateObject(ho, options);
        IObject toUpdate = data.asIObject();
        ModelMapper.setAnnotatedObject(updated, toUpdate);
        this.gateway.updateObject(toUpdate, options);
        return PojoMapper.asDataObject(updated);
    }

    @Override
    public DataObject createDataObject(DataObject child, DataObject parent) throws DSOutOfServiceException, DSAccessException {
        if (child == null) {
            throw new IllegalArgumentException("The child cannot be null.");
        }
        IObject obj = ModelMapper.createIObject(child, parent);
        if (obj == null) {
            throw new NullPointerException("Cannot convert object.");
        }
        Map options = new PojoOptions().map();
        IObject created = this.gateway.createObject(obj, options);
        if (parent != null) {
            ModelMapper.linkParentToNewChild(created, parent.asIObject());
        }
        return PojoMapper.asDataObject(created);
    }

    @Override
    public Set removeDataObjects(Set children, DataObject parent) throws DSOutOfServiceException, DSAccessException {
        if (children == null) {
            throw new IllegalArgumentException("The children cannot be null.");
        }
        if (children.size() == 0) {
            throw new IllegalArgumentException("No children to remove.");
        }
        Iterator i = children.iterator();
        if (parent == null) {
            int index = 0;
            IObject[] ioObjects = new IObject[children.size()];
            while (i.hasNext()) {
                IObject o;
                ioObjects[index] = o = this.gateway.findIObject(((DataObject)i.next()).asIObject());
                ++index;
            }
            this.gateway.deleteObjects(ioObjects);
        } else {
            this.cut(parent, children);
        }
        return children;
    }

    @Override
    public DataObject updateDataObject(DataObject object) throws DSOutOfServiceException, DSAccessException {
        if (object == null) {
            throw new DSAccessException("No object to update.");
        }
        IObject ho = null;
        IObject oldObject = null;
        oldObject = object.asIObject();
        ho = this.gateway.findIObject(oldObject);
        if (ho == null) {
            return null;
        }
        ModelMapper.fillIObject(oldObject, ho);
        ModelMapper.unloadCollections(ho);
        IObject updated = this.gateway.updateObject(ho, new PojoOptions().map());
        return PojoMapper.asDataObject(updated);
    }

    @Override
    public Set classify(Set<ImageData> images, Set<CategoryData> categories) throws DSOutOfServiceException, DSAccessException {
        Iterator<Object> i;
        if (images == null) {
            throw new IllegalArgumentException("No images to classify.");
        }
        if (categories == null) {
            throw new IllegalArgumentException("No categories specified.");
        }
        Iterator<CategoryData> category = categories.iterator();
        ArrayList<ILink> objects = new ArrayList<ILink>();
        while (category.hasNext()) {
            IObject ioParent = ((DataObject)category.next()).asIObject();
            Iterator<ImageData> image = images.iterator();
            while (image.hasNext()) {
                IObject ioChild = ((DataObject)image.next()).asIObject();
                objects.add(ModelMapper.linkParentToChild(ioChild, ioParent));
            }
        }
        if (objects.size() != 0) {
            i = objects.iterator();
            IObject[] array = new IObject[objects.size()];
            int index = 0;
            while (i.hasNext()) {
                array[index] = (IObject)i.next();
                ++index;
            }
            this.gateway.createObjects(array, new PojoOptions().map());
        }
        i = images.iterator();
        HashSet<Long> ids = new HashSet<Long>(images.size());
        while (i.hasNext()) {
            ids.add(new Long(((DataObject)i.next()).getId()));
        }
        return this.getImages(ImageData.class, ids, ExperimenterData.class, -1L);
    }

    @Override
    public Set declassify(Set<ImageData> images, Set<CategoryData> categories) throws DSOutOfServiceException, DSAccessException {
        if (images == null) {
            throw new IllegalArgumentException("No images to classify.");
        }
        if (categories == null) {
            throw new IllegalArgumentException("No categories specified.");
        }
        Iterator<CategoryData> category = categories.iterator();
        while (category.hasNext()) {
            this.cut((DataObject)category.next(), images);
        }
        Iterator<ImageData> i = images.iterator();
        HashSet<Long> ids = new HashSet<Long>(images.size());
        while (i.hasNext()) {
            ids.add(new Long(((DataObject)i.next()).getId()));
        }
        return this.getImages(ImageData.class, ids, ExperimenterData.class, -1L);
    }

    @Override
    public Set loadExistingObjects(Class nodeType, Set nodeIDs, Class rootLevel, long rootID) throws DSOutOfServiceException, DSAccessException {
        Iterator j;
        Iterator i;
        Set in;
        Set all = null;
        HashSet<Long> objects = new HashSet<Long>();
        if (nodeType.equals(ProjectData.class)) {
            in = this.loadContainerHierarchy(nodeType, nodeIDs, true, rootLevel, rootID);
            all = this.loadContainerHierarchy(DatasetData.class, null, true, rootLevel, rootID);
            i = in.iterator();
            while (i.hasNext()) {
                j = ((ProjectData)i.next()).getDatasets().iterator();
                while (j.hasNext()) {
                    objects.add(new Long(((DatasetData)j.next()).getId()));
                }
            }
        } else if (nodeType.equals(CategoryGroupData.class)) {
            in = this.loadContainerHierarchy(nodeType, nodeIDs, true, rootLevel, rootID);
            all = this.loadContainerHierarchy(CategoryData.class, null, true, rootLevel, rootID);
            i = in.iterator();
            while (i.hasNext()) {
                j = ((CategoryGroupData)i.next()).getCategories().iterator();
                while (j.hasNext()) {
                    objects.add(new Long(((CategoryData)j.next()).getId()));
                }
            }
        } else if (nodeType.equals(DatasetData.class) || nodeType.equals(CategoryData.class)) {
            in = this.getImages(nodeType, nodeIDs, rootLevel, rootID);
            all = this.getExperimenterImages(rootID);
            i = in.iterator();
            while (i.hasNext()) {
                objects.add(new Long(((ImageData)i.next()).getId()));
            }
        }
        if (all == null) {
            return new HashSet(1);
        }
        Iterator k = all.iterator();
        HashSet<DataObject> toRemove = new HashSet<DataObject>();
        while (k.hasNext()) {
            DataObject ho = (DataObject)k.next();
            Long id = new Long(ho.getId());
            if (!objects.contains(id)) continue;
            toRemove.add(ho);
        }
        all.removeAll(toRemove);
        return all;
    }

    @Override
    public void addExistingObjects(DataObject parent, Set children) throws DSOutOfServiceException, DSAccessException {
        if (parent instanceof ProjectData) {
            try {
                children.toArray(new DatasetData[0]);
            }
            catch (ArrayStoreException ase) {
                throw new IllegalArgumentException("items can only be datasets.");
            }
        } else if (parent instanceof DatasetData) {
            try {
                children.toArray(new ImageData[0]);
            }
            catch (ArrayStoreException ase) {
                throw new IllegalArgumentException("items can only be images.");
            }
        } else if (parent instanceof CategoryGroupData) {
            try {
                children.toArray(new CategoryData[0]);
            }
            catch (ArrayStoreException ase) {
                throw new IllegalArgumentException("items can only be categories.");
            }
        } else if (parent instanceof CategoryData) {
            try {
                children.toArray(new ImageData[0]);
            }
            catch (ArrayStoreException ase) {
                throw new IllegalArgumentException("items can only be images.");
            }
        } else {
            throw new IllegalArgumentException("parent object not supported");
        }
        ArrayList<ILink> objects = new ArrayList<ILink>();
        IObject ioParent = parent.asIObject();
        Iterator child = children.iterator();
        while (child.hasNext()) {
            IObject ioChild = ((DataObject)child.next()).asIObject();
            if (this.gateway.findLink(ioParent, ioChild) != null) continue;
            objects.add(ModelMapper.linkParentToChild(ioChild, ioParent));
        }
        if (objects.size() != 0) {
            Iterator i = objects.iterator();
            IObject[] array = new IObject[objects.size()];
            int index = 0;
            while (i.hasNext()) {
                array[index] = (IObject)i.next();
                ++index;
            }
            this.gateway.createObjects(array, new PojoOptions().map());
        }
    }

    @Override
    public void cutAndPaste(Map toPaste, Map toCut) throws DSOutOfServiceException, DSAccessException {
        if (toPaste == null || toCut == null || toPaste.size() == 0 || toCut.size() == 0) {
            throw new IllegalArgumentException("No data to cut and Paste.");
        }
        for (Object parent : toCut.keySet()) {
            if (!(parent instanceof DataObject)) continue;
            this.cut((DataObject)parent, (Set)toCut.get(parent));
        }
        for (Object parent : toPaste.keySet()) {
            if (!(parent instanceof DataObject)) continue;
            this.addExistingObjects((DataObject)parent, (Set)toPaste.get(parent));
        }
    }

    @Override
    public List getChannelsMetadata(long pixelsID) throws DSOutOfServiceException, DSAccessException {
        List l = this.gateway.getChannelsData(pixelsID);
        Iterator i = l.iterator();
        ArrayList<ChannelMetadata> metadata = new ArrayList<ChannelMetadata>(l.size());
        int index = 0;
        while (i.hasNext()) {
            metadata.add(Mapper.mapChannel(index, (Channel)i.next()));
            ++index;
        }
        return metadata;
    }

    @Override
    public List createAnnotationFor(Set toAnnotate, AnnotationData d) throws DSOutOfServiceException, DSAccessException {
        if (d == null) {
            throw new IllegalArgumentException("No annotation to create.");
        }
        if (toAnnotate == null || toAnnotate.size() == 0) {
            throw new IllegalArgumentException("No DataObject to annotate.");
        }
        Iterator i = toAnnotate.iterator();
        IObject[] toCreate = new IObject[toAnnotate.size()];
        IObject[] objects = new IObject[toAnnotate.size()];
        int index = 0;
        while (i.hasNext()) {
            DataObject annotatedObject = (DataObject)i.next();
            IObject ho = this.gateway.findIObject(annotatedObject.asIObject());
            if (ho == null) continue;
            toCreate[index] = ModelMapper.createAnnotation(ho, d);
            objects[index] = this.gateway.createObject(toCreate[index], new PojoOptions().map());
            ++index;
        }
        ArrayList<DataObject> results = new ArrayList<DataObject>(objects.length);
        for (int j = 0; j < objects.length; ++j) {
            results.add(PojoMapper.asDataObject(ModelMapper.getAnnotatedObject(objects[j])));
        }
        return results;
    }

    @Override
    public List updateAnnotationFor(Map nodes) throws DSOutOfServiceException, DSAccessException {
        if (nodes == null || nodes.size() == 0) {
            throw new IllegalArgumentException("No DataObject to annotate.");
        }
        Map options = new PojoOptions().map();
        Iterator i = nodes.keySet().iterator();
        ArrayList<DataObject> results = new ArrayList<DataObject>(nodes.size());
        while (i.hasNext()) {
            DataObject annotatedObject = (DataObject)i.next();
            IObject object = this.gateway.findIObject(annotatedObject.asIObject());
            if (object == null) continue;
            ModelMapper.unloadCollections(object);
            IObject updated = this.gateway.updateObject(object, options);
            IObject toUpdate = ((AnnotationData)nodes.get(annotatedObject)).asIObject();
            ModelMapper.setAnnotatedObject(updated, toUpdate);
            this.gateway.updateObject(toUpdate, options);
            results.add(PojoMapper.asDataObject(updated));
        }
        return results;
    }

    @Override
    public Map<GroupData, Set> getAvailableGroups() throws DSOutOfServiceException, DSAccessException {
        return this.gateway.getAvailableGroups();
    }

    @Override
    public Set getOrphanContainers(Class nodeType, boolean withLeaves, Class rootLevel, long rootID) throws DSOutOfServiceException, DSAccessException {
        if (nodeType == null) {
            return null;
        }
        if (!nodeType.equals(DatasetData.class) && !nodeType.equals(CategoryData.class)) {
            return null;
        }
        Set r = this.loadContainerHierarchy(nodeType, null, withLeaves, rootLevel, rootID);
        Set parents = null;
        if (nodeType.equals(DatasetData.class)) {
            parents = this.loadContainerHierarchy(ProjectData.class, null, false, rootLevel, rootID);
        } else if (nodeType.equals(CategoryData.class)) {
            parents = this.loadContainerHierarchy(CategoryGroupData.class, null, false, rootLevel, rootID);
        }
        if (parents == null) {
            return null;
        }
        Iterator i = parents.iterator();
        HashSet children = new HashSet();
        while (i.hasNext()) {
            DataObject parent = (DataObject)i.next();
            if (nodeType.equals(DatasetData.class)) {
                children.addAll(((ProjectData)parent).getDatasets());
                continue;
            }
            children.addAll(((CategoryGroupData)parent).getCategories());
        }
        HashSet<Long> childrenIds = new HashSet<Long>();
        for (DataObject child : children) {
            childrenIds.add(new Long(child.getId()));
        }
        HashSet orphans = new HashSet();
        orphans.addAll(r);
        for (DataObject child : r) {
            if (!childrenIds.contains(new Long(child.getId()))) continue;
            orphans.remove(child);
        }
        return orphans;
    }

    @Override
    public Map<Integer, List> getArchivedFiles(String path, long pixelsID) throws DSOutOfServiceException, DSAccessException {
        return this.gateway.getArchivedFiles(path, pixelsID);
    }

    @Override
    public Set classifyChildren(Set containers, Set categories) throws DSOutOfServiceException, DSAccessException {
        if (containers == null || containers.size() == 0) {
            throw new IllegalArgumentException("No containers specified.");
        }
        if (categories == null) {
            throw new IllegalArgumentException("No categories specified.");
        }
        ExperimenterData exp = this.getUserDetails();
        Iterator i = containers.iterator();
        Set images = null;
        Class<DatasetData> klass = null;
        HashSet results = new HashSet();
        while (i.hasNext()) {
            DataObject object = (DataObject)i.next();
            HashSet<Long> ids = new HashSet<Long>(1);
            ids.add(new Long(object.getId()));
            if (object instanceof DatasetData) {
                klass = DatasetData.class;
            } else if (object instanceof CategoryData) {
                klass = CategoryData.class;
            }
            if (klass != null) {
                images = this.getImages(klass, ids, ExperimenterData.class, exp.getId());
            }
            if (images == null) continue;
            results.addAll(this.classify(images, categories));
        }
        return results;
    }

    @Override
    public List annotateChildren(Set folders, AnnotationData data) throws DSOutOfServiceException, DSAccessException {
        if (folders == null || folders.size() == 0) {
            throw new IllegalArgumentException("No DataObject to annotate.");
        }
        if (data == null) {
            throw new IllegalArgumentException("No annotation.");
        }
        Iterator i = folders.iterator();
        Set images = null;
        Class<DatasetData> klass = null;
        ArrayList<DataObject> results = new ArrayList<DataObject>();
        PojoOptions po = new PojoOptions();
        po.noCounts();
        po.allExps();
        Map map = po.map();
        while (i.hasNext()) {
            DataObject object = (DataObject)i.next();
            HashSet<Long> ids = new HashSet<Long>(1);
            ids.add(new Long(object.getId()));
            if (object instanceof DatasetData) {
                klass = DatasetData.class;
            } else if (object instanceof CategoryData) {
                klass = CategoryData.class;
            }
            if (klass != null) {
                images = this.gateway.getContainerImages(klass, ids, map);
            }
            if (images == null) continue;
            Iterator j = images.iterator();
            while (j.hasNext()) {
                DataObject image = this.createAnnotationFor((DataObject)j.next(), data);
                results.add(image);
            }
        }
        return results;
    }

    @Override
    public Boolean changePassword(String oldPassword, String newPassword) throws DSOutOfServiceException, DSAccessException {
        if (newPassword == null || newPassword.trim().length() == 0) {
            throw new IllegalArgumentException("Password not valid.");
        }
        UserCredentials uc = (UserCredentials)this.context.lookup("/user/credentials");
        if (!uc.getPassword().equals(oldPassword)) {
            return Boolean.FALSE;
        }
        this.gateway.changePassword(uc.getUserName(), newPassword);
        uc.resetPassword(newPassword);
        return Boolean.TRUE;
    }

    @Override
    public ExperimenterData updateExperimenter(ExperimenterData exp) throws DSOutOfServiceException, DSAccessException {
        if (exp == null) {
            throw new DSAccessException("No object to update.");
        }
        UserCredentials uc = (UserCredentials)this.context.lookup("/user/credentials");
        Experimenter oldObject = exp.asExperimenter();
        this.gateway.updateExperimenter(oldObject);
        ExperimenterData data = this.gateway.getUserDetails(uc.getUserName());
        this.context.bind("/current_user/details", exp);
        List agents = (List)this.context.lookup("/agents");
        for (AgentInfo agentInfo : agents) {
            agentInfo.getRegistry().bind("/current_user/details", exp);
        }
        return data;
    }

    @Override
    public String getServerName() {
        UserCredentials uc = (UserCredentials)this.context.lookup("/user/credentials");
        return uc.getHostName();
    }
}

