/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJBAccessException;
import javax.ejb.EJBException;
import ome.api.IAdmin;
import ome.api.IPojos;
import ome.api.IQuery;
import ome.api.IUpdate;
import ome.api.RawFileStore;
import ome.api.RawPixelsStore;
import ome.api.ThumbnailStore;
import ome.conditions.ApiUsageException;
import ome.conditions.ValidationException;
import ome.model.IObject;
import ome.model.containers.Category;
import ome.model.containers.CategoryGroup;
import ome.model.containers.Dataset;
import ome.model.containers.Project;
import ome.model.core.Image;
import ome.model.core.OriginalFile;
import ome.model.core.Pixels;
import ome.model.core.PixelsDimensions;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.parameters.Parameters;
import ome.system.Login;
import ome.system.Server;
import ome.system.ServiceFactory;
import ome.util.builders.PojoOptions;
import omeis.providers.re.RenderingEngine;
import org.openmicroscopy.shoola.env.data.DSAccessException;
import org.openmicroscopy.shoola.env.data.DSOutOfServiceException;
import org.openmicroscopy.shoola.env.data.DataServicesFactory;
import org.openmicroscopy.shoola.env.data.util.PojoMapper;
import org.openmicroscopy.shoola.env.rnd.RenderingServiceException;
import pojos.CategoryData;
import pojos.CategoryGroupData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.GroupData;
import pojos.ImageData;
import pojos.ProjectData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OMEROGateway {
    private static final int INC = 256000;
    private static final int MAX_RETRIEVAL = 100;
    private int thumbRetrieval;
    private ServiceFactory entry;
    private ThumbnailStore thumbnailService;
    private RawFileStore fileStore;
    private RawPixelsStore pixelsStore;
    private boolean connected;
    private DataServicesFactory dsFactory;
    private Server server;
    private int port;

    private void handleException(Throwable t, String message) throws DSOutOfServiceException, DSAccessException {
        Throwable cause = t.getCause();
        if (cause instanceof SecurityException) {
            String s = "Cannot access data for security reasons \n";
            throw new DSAccessException(s + message + "\n\n" + this.printErrorText((Exception)cause));
        }
        if (cause instanceof EJBAccessException) {
            String s = "Cannot access data for security reasons \n";
            throw new DSAccessException(s + message + "\n\n" + this.printErrorText((Exception)cause));
        }
        if (cause instanceof ApiUsageException) {
            String s = "Cannot access data, specified parameters not valid \n";
            throw new DSAccessException(s + message + "\n\n" + this.printErrorText((Exception)cause));
        }
        if (cause instanceof ValidationException) {
            String s = "Cannot access data, specified parameters not valid \n";
            throw new DSAccessException(s + message + "\n\n" + this.printErrorText((Exception)cause));
        }
        throw new DSOutOfServiceException(message + "\n\n" + this.printErrorText((Exception)cause));
    }

    private String printErrorText(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    private String getTableForLink(Class klass) {
        String table = null;
        if (klass.equals(Category.class)) {
            table = "CategoryImageLink";
        } else if (klass.equals(Dataset.class)) {
            table = "DatasetImageLink";
        } else if (klass.equals(Project.class)) {
            table = "ProjectDatasetLink";
        } else if (klass.equals(CategoryGroup.class)) {
            table = "CategoryGroupCategoryLink";
        }
        return table;
    }

    private String mapAlgorithmToString(int algorithm) {
        switch (algorithm) {
            case 1: {
                return "CLASSIFICATION_ME";
            }
            case 2: {
                return "CLASSIFICATION_NME";
            }
            case 0: {
                return "DECLASSIFICATION";
            }
        }
        throw new IllegalArgumentException("Algorithm not valid.");
    }

    private String convertPojosToString(Class nodeType) {
        if (nodeType.equals(ProjectData.class)) {
            return Project.class.getName();
        }
        if (nodeType.equals(DatasetData.class)) {
            return Dataset.class.getName();
        }
        if (nodeType.equals(ImageData.class)) {
            return Image.class.getName();
        }
        if (nodeType.equals(CategoryData.class)) {
            return Category.class.getName();
        }
        if (nodeType.equals(CategoryGroupData.class)) {
            return CategoryGroup.class.getName();
        }
        throw new IllegalArgumentException("NodeType not supported");
    }

    private String convertProperty(Class nodeType, String property) {
        if (nodeType.equals(DatasetData.class)) {
            if (property.equals("images")) {
                return "Dataset_imageLinks";
            }
        } else if (nodeType.equals(CategoryData.class)) {
            if (property.equals("images")) {
                return "Category_imageLinks";
            }
        } else {
            throw new IllegalArgumentException("NodeType or property not supported");
        }
        return null;
    }

    private Class convertPojos(Class nodeType) {
        if (nodeType.equals(ProjectData.class)) {
            return Project.class;
        }
        if (nodeType.equals(DatasetData.class)) {
            return Dataset.class;
        }
        if (nodeType.equals(ImageData.class)) {
            return Image.class;
        }
        if (nodeType.equals(CategoryData.class)) {
            return Category.class;
        }
        if (nodeType.equals(CategoryGroupData.class)) {
            return CategoryGroup.class;
        }
        throw new IllegalArgumentException("NodeType not supported");
    }

    private IPojos getIPojosService() {
        return this.entry.getPojosService();
    }

    private IQuery getIQueryService() {
        return this.entry.getQueryService();
    }

    private IUpdate getIUpdateService() {
        return this.entry.getUpdateService();
    }

    private IAdmin getIAdmin() {
        return this.entry.getAdminService();
    }

    private ThumbnailStore getThumbService() {
        if (this.thumbRetrieval == 100) {
            this.thumbRetrieval = 0;
            if (this.thumbnailService != null) {
                this.thumbnailService.close();
            }
            this.thumbnailService = null;
        }
        if (this.thumbnailService == null) {
            this.thumbnailService = this.entry.createThumbnailService();
        }
        ++this.thumbRetrieval;
        return this.thumbnailService;
    }

    private RawFileStore getRawFileService() {
        return this.entry.createRawFileStore();
    }

    private RenderingEngine getRenderingService() {
        return this.entry.createRenderingEngine();
    }

    private RawPixelsStore getPixelsStore() {
        return this.entry.createRawPixelsStore();
    }

    private synchronized void needDefault(long pixelsID, RenderingEngine re) {
        if (re == null) {
            ThumbnailStore service = this.getThumbService();
            if (!service.setPixelsId(pixelsID)) {
                service.resetDefaults();
                service.setPixelsId(pixelsID);
            }
        } else if (!re.lookupRenderingDef(pixelsID)) {
            re.resetDefaults();
            re.lookupRenderingDef(pixelsID);
        }
    }

    private boolean isSystemGroup(ExperimenterGroup group) {
        String n = group.getName();
        return "system".equals(n) || "user".equals(n) || "default".equals(n);
    }

    private void resetFactory(String userName, String password) {
        this.entry = new ServiceFactory(this.server, new Login(userName, password));
        if (this.thumbnailService != null) {
            this.thumbnailService.close();
        }
        this.thumbnailService = null;
        this.thumbRetrieval = 0;
    }

    OMEROGateway(int port, DataServicesFactory dsFactory) {
        if (dsFactory == null) {
            throw new IllegalArgumentException("No Data service factory.");
        }
        this.dsFactory = dsFactory;
        this.port = port;
        this.thumbRetrieval = 0;
    }

    boolean isConnected() {
        return this.connected;
    }

    ExperimenterData getUserDetails(String name) throws DSOutOfServiceException {
        try {
            IPojos service = this.getIPojosService();
            HashSet<String> set = new HashSet<String>(1);
            set.add(name);
            Map m = PojoMapper.asDataObjects(service.getUserDetails(set, new PojoOptions().map()));
            ExperimenterData data = (ExperimenterData)m.get(name);
            if (data == null) {
                throw new DSOutOfServiceException("Cannot retrieve user's data");
            }
            return data;
        }
        catch (Exception e) {
            throw new DSOutOfServiceException("Cannot retrieve user's data " + this.printErrorText(e));
        }
    }

    ExperimenterData login(String userName, String password, String hostName) throws DSOutOfServiceException {
        try {
            this.server = new Server(hostName, this.port);
            this.entry = new ServiceFactory(this.server, new Login(userName, password));
            this.connected = true;
            return this.getUserDetails(userName);
        }
        catch (Exception e) {
            this.connected = false;
            String s = "Can't connect to OMERO. OMERO info not valid.\n\n";
            s = s + this.printErrorText(e);
            throw new DSOutOfServiceException(s, e);
        }
    }

    void logout() {
        this.connected = false;
        if (this.thumbnailService != null) {
            this.thumbnailService.close();
        }
    }

    Set loadContainerHierarchy(Class rootNodeType, Set rootNodeIDs, Map options) throws DSOutOfServiceException, DSAccessException {
        try {
            IPojos service = this.getIPojosService();
            HashSet s = new HashSet();
            Iterator j = s.iterator();
            return PojoMapper.asDataObjects(service.loadContainerHierarchy(this.convertPojos(rootNodeType), rootNodeIDs, options));
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot load hierarchy for " + rootNodeType + ".");
            return new HashSet();
        }
    }

    Set findContainerHierarchy(Class rootNodeType, Set leavesIDs, Map options) throws DSOutOfServiceException, DSAccessException {
        try {
            IPojos service = this.getIPojosService();
            return PojoMapper.asDataObjects(service.findContainerHierarchies(this.convertPojos(rootNodeType), leavesIDs, options));
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot find hierarchy for " + rootNodeType + ".");
            return new HashSet();
        }
    }

    Map findAnnotations(Class nodeType, Set nodeIDs, Set annotatorIDs, Map options) throws DSOutOfServiceException, DSAccessException {
        try {
            IPojos service = this.getIPojosService();
            return PojoMapper.asDataObjects(service.findAnnotations(this.convertPojos(nodeType), nodeIDs, annotatorIDs, options));
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot find annotations for " + nodeType + ".");
            return new HashMap();
        }
    }

    Set findCGCPaths(Set imgIDs, int algorithm, Map options) throws DSOutOfServiceException, DSAccessException {
        try {
            IPojos service = this.getIPojosService();
            return PojoMapper.asDataObjects(service.findCGCPaths(imgIDs, this.mapAlgorithmToString(algorithm), options));
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot find CGC paths.");
            new Long(1L);
            return new HashSet();
        }
    }

    Set getContainerImages(Class nodeType, Set nodeIDs, Map options) throws DSOutOfServiceException, DSAccessException {
        try {
            IPojos service = this.getIPojosService();
            return PojoMapper.asDataObjects(service.getImages(this.convertPojos(nodeType), nodeIDs, options));
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot find images for " + nodeType + ".");
            return new HashSet();
        }
    }

    Set getUserImages(Map options) throws DSOutOfServiceException, DSAccessException {
        try {
            IPojos service = this.getIPojosService();
            return PojoMapper.asDataObjects(service.getUserImages(options));
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot find user images.");
            return new HashSet();
        }
    }

    Map getCollectionCount(Class rootNodeType, String property, Set rootNodeIDs, Map options) throws DSOutOfServiceException, DSAccessException {
        try {
            IPojos service = this.getIPojosService();
            String p = this.convertProperty(rootNodeType, property);
            if (p == null) {
                return null;
            }
            return PojoMapper.asDataObjects(service.getCollectionCount(this.convertPojosToString(rootNodeType), p, rootNodeIDs, options));
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot count the collection.");
            return new HashMap();
        }
    }

    IObject createObject(IObject object, Map options) throws DSOutOfServiceException, DSAccessException {
        try {
            IPojos service = this.getIPojosService();
            return service.createDataObject(object, options);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot update the object.");
            return null;
        }
    }

    IObject[] createObjects(IObject[] objects, Map options) throws DSOutOfServiceException, DSAccessException {
        try {
            IPojos service = this.getIPojosService();
            IObject[] results = service.createDataObjects(objects, options);
            return results;
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot update the object.");
            return null;
        }
    }

    void deleteObject(IObject object) throws DSOutOfServiceException, DSAccessException {
        try {
            IUpdate service = this.getIUpdateService();
            service.deleteObject(object);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot delete the object.");
        }
    }

    void deleteObjects(IObject[] objects) throws DSOutOfServiceException, DSAccessException {
        try {
            IUpdate service = this.getIUpdateService();
            for (int i = 0; i < objects.length; ++i) {
                service.deleteObject(objects[i]);
            }
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot delete the object.");
        }
    }

    IObject updateObject(IObject object, Map options) throws DSOutOfServiceException, DSAccessException {
        try {
            IPojos service = this.getIPojosService();
            return service.updateDataObject(object, options);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot update the object.");
            return null;
        }
    }

    IObject[] updateObjects(IObject[] objects, Map options) throws DSOutOfServiceException, DSAccessException {
        try {
            IPojos service = this.getIPojosService();
            return service.updateDataObjects(objects, options);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot update the object.");
            return null;
        }
    }

    PixelsDimensions getPixelsDimensions(long pixelsID) throws DSOutOfServiceException, DSAccessException {
        try {
            IQuery service = this.getIQueryService();
            Pixels pixs = (Pixels)service.get(Pixels.class, pixelsID);
            return (PixelsDimensions)service.get(PixelsDimensions.class, pixs.getPixelsDimensions().getId().longValue());
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the dimension of the pixels set.");
            return null;
        }
    }

    Pixels getPixels(long pixelsID) throws DSOutOfServiceException, DSAccessException {
        try {
            IQuery service = this.getIQueryService();
            Pixels pixs = (Pixels)service.findByQuery("select p from Pixels as p left outer join fetch p.pixelsType as pt left outer join fetch p.pixelsDimensions where p.id = :id", new Parameters().addId(new Long(pixelsID)));
            return pixs;
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.handleException(t, "Cannot retrieve the pixels set of the pixels set.");
            return null;
        }
    }

    List getChannelsData(long pixelsID) throws DSOutOfServiceException, DSAccessException {
        try {
            IQuery service = this.getIQueryService();
            Pixels pixs = (Pixels)service.findByQuery("select p from Pixels as p left outer join fetch p.pixelsType as pt left outer join fetch p.channels as c left outer join fetch p.pixelsDimensions left outer join fetch c.logicalChannel as lc left outer join fetch c.statsInfo where p.id = :id", new Parameters().addId(new Long(pixelsID)));
            return pixs.getChannels();
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the channelsData for the pixels set " + pixelsID);
            return null;
        }
    }

    synchronized byte[] getThumbnail(long pixelsID, int sizeX, int sizeY) throws RenderingServiceException, DSOutOfServiceException {
        try {
            ThumbnailStore service = this.getThumbService();
            this.needDefault(pixelsID, null);
            return service.getThumbnailDirect(new Integer(sizeX), new Integer(sizeY));
        }
        catch (Throwable t) {
            if (this.thumbnailService != null) {
                this.thumbnailService.close();
            }
            this.thumbnailService = null;
            if (t instanceof EJBException || t.getCause() instanceof IllegalStateException) {
                throw new DSOutOfServiceException("Thumbnail service null for pixelsID: " + pixelsID + "\n\n" + this.printErrorText((Exception)t));
            }
            throw new RenderingServiceException("Cannot get thumbnail", t);
        }
    }

    synchronized byte[] getThumbnailByLongestSide(long pixelsID, int maxLength) throws RenderingServiceException, DSOutOfServiceException {
        try {
            ThumbnailStore service = this.getThumbService();
            this.needDefault(pixelsID, null);
            return service.getThumbnailByLongestSideDirect(Integer.valueOf(maxLength));
        }
        catch (Throwable t) {
            if (this.thumbnailService != null) {
                this.thumbnailService.close();
            }
            this.thumbnailService = null;
            if (t instanceof EJBException || t.getCause() instanceof IllegalStateException) {
                throw new DSOutOfServiceException("Thumbnail service null for pixelsID: " + pixelsID + "\n\n" + this.printErrorText((Exception)t));
            }
            throw new RenderingServiceException("Cannot get thumbnail", t);
        }
    }

    synchronized RenderingEngine createRenderingEngine(long pixelsID) throws DSOutOfServiceException, DSAccessException {
        try {
            RenderingEngine service = this.getRenderingService();
            service.lookupPixels(pixelsID);
            this.needDefault(pixelsID, service);
            service.load();
            return service;
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot start the Rendering Engine.");
            return null;
        }
    }

    IObject findLink(IObject parent, IObject child) throws DSOutOfServiceException, DSAccessException {
        try {
            String table = this.getTableForLink(parent.getClass());
            if (table == null) {
                return null;
            }
            String sql = "select link from " + table + " as link where " + "link.parent.id = :parentID and link.child.id = :childID";
            IQuery service = this.getIQueryService();
            Parameters param = new Parameters();
            param.addLong("parentID", parent.getId());
            param.addLong("childID", child.getId());
            return service.findByQuery(sql, param);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the requested link for parent ID: " + parent.getId() + " and child " + "ID: " + child.getId());
            return null;
        }
    }

    List findLinks(IObject parent, List children) throws DSOutOfServiceException, DSAccessException {
        try {
            String table = this.getTableForLink(parent.getClass());
            if (table == null) {
                return null;
            }
            String sql = "select link from " + table + " as link where " + "link.parent.id = :parentID and link.child.id in " + "(:childIDs)";
            IQuery service = this.getIQueryService();
            Parameters param = new Parameters();
            param.addLong("parentID", parent.getId());
            param.addList("childIDs", children);
            return service.findAllByQuery(sql, param);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the requested link for parent ID: " + parent.getId());
            return null;
        }
    }

    IObject findIObject(IObject o) throws DSOutOfServiceException, DSAccessException {
        try {
            IQuery service = this.getIQueryService();
            return service.find(o.getClass(), o.getId().longValue());
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the requested object with object ID: " + o.getId());
            return null;
        }
    }

    IObject findIObject(Class klass, long id) throws DSOutOfServiceException, DSAccessException {
        try {
            IQuery service = this.getIQueryService();
            return service.find(klass, id);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the requested object with object ID: " + id);
            return null;
        }
    }

    Map<GroupData, Set> getAvailableGroups() throws DSOutOfServiceException, DSAccessException {
        try {
            IAdmin service = this.getIAdmin();
            List groups = service.lookupGroups();
            Iterator i = groups.iterator();
            HashMap<GroupData, Set> pojos = new HashMap<GroupData, Set>();
            while (i.hasNext()) {
                ExperimenterGroup group = (ExperimenterGroup)i.next();
                if (this.isSystemGroup(group)) continue;
                DataObject pojoGroup = PojoMapper.asDataObject((IObject)group);
                Experimenter[] experimenters = service.containedExperimenters(group.getId());
                pojos.put((GroupData)pojoGroup, PojoMapper.asDataObjects((IObject[])experimenters));
            }
            return pojos;
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot retrieve the available groups ");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Integer, List> getArchivedFiles(String path, long pixelsID) throws DSOutOfServiceException, DSAccessException {
        IQuery service = this.getIQueryService();
        List files = null;
        try {
            files = service.findAllByQuery("select ofile from OriginalFile as ofile left join ofile.pixelsFileMaps as pfm left join pfm.child as child where child.id = :id", new Parameters().addId(new Long(pixelsID)));
        }
        catch (Exception e) {
            throw new DSAccessException("Cannot retrieve original file", e);
        }
        HashMap<Integer, List> result = new HashMap<Integer, List>();
        if (files == null || files.size() == 0) {
            return result;
        }
        RawFileStore store = this.getRawFileService();
        Iterator i = files.iterator();
        int offset = 0;
        ArrayList<String> notDownloaded = new ArrayList<String>();
        while (i.hasNext()) {
            OriginalFile of = (OriginalFile)i.next();
            store.setFileId(of.getId().longValue());
            File f = new File(path + of.getName());
            try {
                FileOutputStream stream = new FileOutputStream(f);
                int size = of.getSize().intValue();
                try {
                    try {
                        offset = 0;
                        while (offset + 256000 < size) {
                            stream.write(store.read((long)offset, 256000));
                            offset += 256000;
                        }
                    }
                    finally {
                        stream.write(store.read((long)offset, size - offset));
                    }
                }
                catch (Exception e) {
                    stream.close();
                    f.delete();
                    notDownloaded.add(of.getName());
                }
            }
            catch (IOException e) {
                f.delete();
                notDownloaded.add(of.getName());
                throw new DSAccessException("Cannot create the file", e);
            }
        }
        result.put(files.size(), notDownloaded);
        return result;
    }

    void changePassword(String userName, String password) throws DSOutOfServiceException, DSAccessException {
        IAdmin service = this.getIAdmin();
        try {
            service.changePassword(password);
            this.resetFactory(userName, password);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot modify password. ");
        }
    }

    void updateExperimenter(Experimenter exp) throws DSOutOfServiceException, DSAccessException {
        IAdmin service = this.getIAdmin();
        try {
            service.updateSelf(exp);
        }
        catch (Throwable t) {
            this.handleException(t, "Cannot update the user. ");
        }
    }

    byte[] getPlane(long pixelsID, int z, int t, int c) throws DSOutOfServiceException, DSAccessException {
        RawPixelsStore service = this.getPixelsStore();
        try {
            service.setPixelsId(pixelsID);
            return service.getPlane(Integer.valueOf(z), Integer.valueOf(c), Integer.valueOf(t));
        }
        catch (Throwable e) {
            this.handleException(e, "Cannot retrieve the plane (z=" + z + ", t=" + t + ", c=" + c + ") for pixelsID: " + pixelsID);
            return null;
        }
    }
}

