/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data;

import java.util.List;
import org.openmicroscopy.shoola.env.Container;
import org.openmicroscopy.shoola.env.config.AgentInfo;
import org.openmicroscopy.shoola.env.config.OMEROInfo;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.DSOutOfServiceException;
import org.openmicroscopy.shoola.env.data.OMEROGateway;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.OmeroDataServiceImpl;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.data.OmeroImageServiceImpl;
import org.openmicroscopy.shoola.env.data.login.LoginService;
import org.openmicroscopy.shoola.env.data.login.UserCredentials;
import org.openmicroscopy.shoola.env.data.views.DataViewsFactory;
import pojos.ExperimenterData;

public class DataServicesFactory {
    private static DataServicesFactory singleton;
    private Registry registry;
    private OMEROGateway omeroGateway;
    private OmeroDataService ops;
    private OmeroImageService rds;

    public static DataServicesFactory getInstance(Container c) throws DSOutOfServiceException {
        if (c == null) {
            throw new NullPointerException();
        }
        if (singleton == null) {
            singleton = new DataServicesFactory(c);
        }
        return singleton;
    }

    private DataServicesFactory(Container c) throws DSOutOfServiceException {
        this.registry = c.getRegistry();
        OMEROInfo omeroInfo = (OMEROInfo)this.registry.lookup("/services/OMERODS");
        this.omeroGateway = new OMEROGateway(omeroInfo.getPort(), this);
        this.ops = new OmeroDataServiceImpl(this.omeroGateway, this.registry);
        this.rds = new OmeroImageServiceImpl(this.omeroGateway, this.registry);
        DataViewsFactory.initialize(c);
    }

    public OmeroDataService getOS() {
        return this.ops;
    }

    public OmeroImageService getRDS() {
        return this.rds;
    }

    public LoginService getLoginService() {
        return (LoginService)this.registry.lookup("/services/Login");
    }

    public void connect(UserCredentials uc) throws DSOutOfServiceException {
        if (uc == null) {
            throw new NullPointerException("No user credentials.");
        }
        ExperimenterData exp = this.omeroGateway.login(uc.getUserName(), uc.getPassword(), uc.getHostName());
        this.registry.bind("/current_user/details", exp);
        List agents = (List)this.registry.lookup("/agents");
        for (AgentInfo agentInfo : agents) {
            agentInfo.getRegistry().bind("/current_user/details", exp);
        }
    }

    public boolean isConnected() {
        return this.omeroGateway.isConnected();
    }

    public void shutdown() {
        ((OmeroImageServiceImpl)this.rds).shutDown();
        this.omeroGateway.logout();
    }
}

