/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.config;

import org.openmicroscopy.shoola.env.config.ConfigException;
import org.openmicroscopy.shoola.env.config.Parser;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.config.RegistryImpl;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.OmeroImageService;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.log.Logger;
import org.openmicroscopy.shoola.env.ui.TaskBar;
import org.openmicroscopy.shoola.env.ui.UserNotifier;

public class RegistryFactory {
    public static Registry makeNew() {
        return new RegistryImpl();
    }

    public static Registry makeNew(String file) throws ConfigException {
        RegistryImpl reg = new RegistryImpl();
        Parser p = new Parser(file, reg);
        p.parse();
        return reg;
    }

    public static void fillFromFile(String file, Registry reg) throws ConfigException {
        Parser p = new Parser(file, (RegistryImpl)reg);
        p.parse();
    }

    public static void linkEventBus(EventBus eb, Registry reg) {
        ((RegistryImpl)reg).setEventBus(eb);
    }

    public static void linkRDS(OmeroImageService rds, Registry reg) {
        ((RegistryImpl)reg).setRenderingService(rds);
    }

    public static void linkTaskBar(TaskBar tb, Registry reg) {
        ((RegistryImpl)reg).setTaskBar(tb);
    }

    public static void linkLogger(Logger logger, Registry reg) {
        ((RegistryImpl)reg).setLogger(logger);
    }

    public static void linkUserNotifier(UserNotifier un, Registry reg) {
        ((RegistryImpl)reg).setUserNotifier(un);
    }

    public static void linkOS(OmeroDataService os, Registry reg) {
        ((RegistryImpl)reg).setOS(os);
    }
}

