/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.classifier.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.openmicroscopy.shoola.agents.util.classifier.view.ClassifierControl;
import org.openmicroscopy.shoola.agents.util.classifier.view.ClassifierFactory;
import org.openmicroscopy.shoola.agents.util.classifier.view.ClassifierModel;
import org.openmicroscopy.shoola.agents.util.classifier.view.ClassifierUI;
import org.openmicroscopy.shoola.agents.util.classifier.view.StatusBar;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class ClassifierView
extends JDialog {
    private static final String TITLE = "Categorise";
    private static final String ADD_PANEL_TITLE = "Categorise";
    private static final String PANEL_NOTE = "Expand list to select the categories to add the images to.";
    private static final String REMOVE_PANEL_NOTE = "The image is currently classified under the following categories. ";
    private static final String ADD_PANEL_TEXT = "Categorise the selected images.";
    private static final String REMOVE_PANEL_TITLE = "Decategorise";
    private static final String REMOVE_PANEL_TEXT = "Decategorise the following image: ";
    private static final String BULK_PANEL_TEXT = "Categorise the images  contained in the selected folders.";
    private static final Dimension DEFAULT_SIZE = new Dimension(700, 500);
    private static final Dimension H_SPACER_SIZE = new Dimension(5, 10);
    private ClassifierControl controller;
    private ClassifierModel model;
    private ClassifierUI classifierUI;
    private StatusBar statusBar;
    private JButton selectAll;
    private JButton deselectAll;
    private boolean pack;

    private void initComponents() {
        this.selectAll = new JButton("Select All");
        this.selectAll.setToolTipText("Select all categories");
        this.selectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassifierView.this.classifierUI.selectAll();
            }
        });
        this.selectAll.setEnabled(false);
        this.deselectAll = new JButton("Deselect All");
        this.deselectAll.setToolTipText("Deselect all categories");
        this.deselectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassifierView.this.classifierUI.deselectAll();
            }
        });
        this.deselectAll.setEnabled(false);
    }

    private JPanel buildSelectToolBar() {
        JPanel bar = new JPanel();
        bar.setBorder(null);
        bar.add(this.selectAll);
        bar.add(Box.createRigidArea(H_SPACER_SIZE));
        bar.add(this.deselectAll);
        return UIUtilities.buildComponentPanel(bar);
    }

    private JPanel buildControlsToolBar() {
        JPanel bar = new JPanel();
        bar.setBorder(null);
        JButton b = new JButton(this.controller.getAction(ClassifierControl.FINISH));
        bar.add(b);
        this.getRootPane().setDefaultButton(b);
        bar.add(Box.createRigidArea(H_SPACER_SIZE));
        b = new JButton(this.controller.getAction(ClassifierControl.CANCEL));
        bar.add(b);
        return UIUtilities.buildComponentPanelRight(bar);
    }

    private JPanel buildBody() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        p.add(this.classifierUI);
        p.add(new JSeparator());
        JPanel bars = new JPanel();
        bars.setLayout(new BoxLayout(bars, 0));
        bars.add(this.buildSelectToolBar());
        bars.add(this.buildControlsToolBar());
        p.add(bars);
        return p;
    }

    private void buildGUI() {
        IconManager icons = IconManager.getInstance();
        TitlePanel tp = new TitlePanel(this.getWindowTitle(), this.getWindowText(), this.getWindowNote(), icons.getIcon(20));
        Container c = this.getContentPane();
        c.add((Component)tp, "North");
        c.add((Component)this.buildBody(), "Center");
        c.add((Component)this.statusBar, "South");
    }

    private String getWindowTitle() {
        switch (this.model.getMode()) {
            case 0: 
            case 2: {
                return "Categorise";
            }
            case 1: {
                return REMOVE_PANEL_TITLE;
            }
        }
        return "";
    }

    private String getWindowText() {
        switch (this.model.getMode()) {
            case 0: {
                return ADD_PANEL_TEXT;
            }
            case 1: {
                return REMOVE_PANEL_TEXT;
            }
            case 2: {
                return BULK_PANEL_TEXT;
            }
        }
        return "";
    }

    private String getWindowNote() {
        switch (this.model.getMode()) {
            case 0: 
            case 2: {
                return PANEL_NOTE;
            }
            case 1: {
                return REMOVE_PANEL_NOTE;
            }
        }
        return "";
    }

    private void setProperties() {
        this.setModal(true);
        this.setTitle("Categorise");
    }

    ClassifierView() {
        super(ClassifierFactory.getOwner());
        this.setProperties();
    }

    void initialize(ClassifierModel model, ClassifierControl controller) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        this.controller = controller;
        this.model = model;
        this.statusBar = new StatusBar();
        this.classifierUI = new ClassifierUI(model, controller);
        this.initComponents();
        this.setTitle(this.getWindowTitle());
        this.buildGUI();
    }

    void setStatus(String text, boolean hide) {
        this.statusBar.setStatus(text);
        this.statusBar.setProgress(hide);
    }

    void showClassifications() {
        Set paths = this.model.getClassificationPaths();
        boolean b = true;
        if (paths == null || paths.size() == 0) {
            b = false;
            this.pack = true;
        }
        this.selectAll.setEnabled(b);
        this.deselectAll.setEnabled(b);
        this.classifierUI.showClassifications();
    }

    Set getSelectedPaths() {
        return this.classifierUI.getSelectedPaths();
    }

    void finish() {
        this.selectAll.setEnabled(false);
        this.deselectAll.setEnabled(false);
    }

    void setOnScreen() {
        if (this.pack) {
            this.pack();
        } else {
            this.setSize(DEFAULT_SIZE);
        }
        UIUtilities.centerAndShow(this);
    }
}

