/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.classifier.view;

import java.awt.Color;
import java.awt.Component;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.agents.util.classifier.view.ClassifierControl;
import org.openmicroscopy.shoola.agents.util.classifier.view.ClassifierModel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.clsf.TreeCheck;
import org.openmicroscopy.shoola.util.ui.clsf.TreeCheckNode;
import pojos.CategoryData;

class ClassifierUI
extends JScrollPane {
    private static final String ADD_UNCLASSIFIED_TEXT = "The image cannot be categorised. Please create a category first.";
    private static final String REMOVE_UNCLASSIFIED_TEXT = "The selected image hasn't been categorised.";
    private ClassifierModel model;
    private ClassifierControl controller;
    private TreeCheck tree;
    private ViewerSorter sorter;

    private void initComponents() {
        this.sorter = new ViewerSorter();
        this.tree = new TreeCheck("", null);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.addPropertyChangeListener("nodeSelected", this.controller);
    }

    private void buildGUI() {
        this.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
    }

    private void buildTreeNode(TreeCheckNode parent, List nodes) {
        DefaultTreeModel tm = (DefaultTreeModel)this.tree.getModel();
        for (TreeCheckNode display : nodes) {
            tm.insertNodeInto(display, parent, parent.getChildCount());
            this.tree.expandPath(new TreePath(display.getPath()));
            Set children = display.getChildrenDisplay();
            if (children.size() == 0) continue;
            this.buildTreeNode(display, this.sorter.sort(children));
        }
    }

    private JComponent getClassificationComponent() {
        Set paths = this.model.getClassificationPaths();
        if (paths.size() == 0) {
            JPanel p = new JPanel();
            p.setBorder(BorderFactory.createEmptyBorder(5, 5, 10, 10));
            JLabel label = UIUtilities.setTextFont(this.getUnclassifiedNote());
            label.setHorizontalAlignment(2);
            p.add((Component)label, "Center");
            return UIUtilities.buildComponentPanel(p);
        }
        DefaultTreeModel dtm = (DefaultTreeModel)this.tree.getModel();
        TreeCheckNode root = (TreeCheckNode)dtm.getRoot();
        Iterator i = paths.iterator();
        while (i.hasNext()) {
            root.addChildDisplay((TreeCheckNode)i.next());
        }
        this.buildTreeNode(root, this.sorter.sort(paths));
        dtm.reload();
        return this.tree;
    }

    private String getUnclassifiedNote() {
        switch (this.model.getMode()) {
            case 0: {
                return ADD_UNCLASSIFIED_TEXT;
            }
            case 1: {
                return REMOVE_UNCLASSIFIED_TEXT;
            }
        }
        return "";
    }

    void showClassifications() {
        this.getViewport().add(this.getClassificationComponent());
    }

    Set getSelectedPaths() {
        Set nodes = this.tree.getSelectedNodes();
        if (nodes == null || nodes.size() == 0) {
            return null;
        }
        HashSet<Object> paths = new HashSet<Object>(nodes.size());
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            Object object = ((TreeCheckNode)i.next()).getUserObject();
            if (!(object instanceof CategoryData)) continue;
            paths.add(object);
        }
        return paths;
    }

    ClassifierUI(ClassifierModel model, ClassifierControl controller) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        this.model = model;
        this.controller = controller;
        this.initComponents();
        this.buildGUI();
    }

    void selectAll() {
        this.tree.selectAllNodes();
    }

    void deselectAll() {
        this.tree.deselectAllNodes();
    }
}

