/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.classifier.view;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openmicroscopy.shoola.agents.util.classifier.ClassificationsLoader;
import org.openmicroscopy.shoola.agents.util.classifier.ClassificationsSaver;
import org.openmicroscopy.shoola.agents.util.classifier.ClassifierLoader;
import org.openmicroscopy.shoola.agents.util.classifier.view.Classifier;
import org.openmicroscopy.shoola.agents.util.classifier.view.ClassifierFactory;
import pojos.ExperimenterData;
import pojos.ImageData;

class ClassifierModel {
    private int state;
    private Set toClassify;
    private long rootID;
    private Set classificationPaths;
    private int mode;
    private ClassifierLoader currentLoader;
    protected Classifier component;

    ClassifierModel(Set objects, long rootID, int m) {
        this.toClassify = objects;
        this.rootID = rootID;
        this.mode = m;
        this.state = 1;
    }

    ClassifierModel(Set objects, long rootID) {
        this.toClassify = objects;
        this.rootID = rootID;
        this.mode = 2;
        this.state = 1;
    }

    void initialize(Classifier component) {
        this.component = component;
    }

    int getState() {
        return this.state;
    }

    void discard() {
        this.cancel();
        this.state = 2;
    }

    void cancel() {
        if (this.currentLoader != null) {
            this.currentLoader.cancel();
            this.currentLoader = null;
        }
        this.state = 3;
    }

    void fireClassificationPathsLoading() {
        if (this.mode == 2) {
            this.currentLoader = new ClassificationsLoader(this.component, this.rootID);
            this.currentLoader.load();
        } else {
            Iterator i = this.toClassify.iterator();
            HashSet<Long> ids = new HashSet<Long>(this.toClassify.size());
            while (i.hasNext()) {
                Object object = i.next();
                if (!(object instanceof ImageData)) continue;
                ids.add(new Long(((ImageData)object).getId()));
            }
            this.currentLoader = new ClassificationsLoader(this.component, ids, this.rootID, this.mode);
            this.currentLoader.load();
        }
        this.state = 4;
    }

    void fireClassificationsSaving(Set categories) {
        this.currentLoader = new ClassificationsSaver(this.component, this.toClassify, categories, this.mode);
        this.currentLoader.load();
        this.state = 5;
    }

    void setClassificationPaths(Set paths) {
        this.classificationPaths = paths;
        this.state = 3;
    }

    Set getClassificationPaths() {
        return this.classificationPaths;
    }

    int getMode() {
        return this.mode;
    }

    long getRootGroupID() {
        return this.rootID;
    }

    long getUserID() {
        return ((ExperimenterData)ClassifierFactory.getRegistry().lookup("/current_user/details")).getId();
    }
}

