/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.classifier.view;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.agents.util.classifier.actions.ClassifierAction;
import org.openmicroscopy.shoola.agents.util.classifier.actions.CloseAction;
import org.openmicroscopy.shoola.agents.util.classifier.actions.FinishAction;
import org.openmicroscopy.shoola.agents.util.classifier.view.Classifier;
import org.openmicroscopy.shoola.agents.util.classifier.view.ClassifierView;

class ClassifierControl
implements ChangeListener,
PropertyChangeListener {
    static final Integer CANCEL = new Integer(0);
    static final Integer FINISH = new Integer(1);
    private static final String LOADING_MSG = "Loading...";
    private static final String SAVING_MSG = "Saving data...";
    private Classifier model;
    private ClassifierView view;
    private Map<Integer, ClassifierAction> actionsMap;

    private void createActions() {
        this.actionsMap.put(CANCEL, new CloseAction(this.model));
        this.actionsMap.put(FINISH, new FinishAction(this.model));
    }

    private void attachListeners() {
        this.model.addChangeListener(this);
        this.view.setDefaultCloseOperation(0);
    }

    ClassifierControl(Classifier model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.actionsMap = new HashMap<Integer, ClassifierAction>();
    }

    void initialize(ClassifierView view) {
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.view = view;
        this.createActions();
        this.attachListeners();
    }

    ClassifierAction getAction(Integer id) {
        return this.actionsMap.get(id);
    }

    public void stateChanged(ChangeEvent e) {
        switch (this.model.getState()) {
            case 3: {
                this.view.setStatus("", true);
                this.view.setOnScreen();
                break;
            }
            case 4: {
                this.view.setStatus(LOADING_MSG, false);
                break;
            }
            case 2: {
                this.view.setVisible(false);
                this.view.dispose();
                break;
            }
            case 5: {
                this.view.setStatus(SAVING_MSG, false);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent pce) {
        String name = pce.getPropertyName();
        if ("nodeSelected".equals(name)) {
            int i = (Integer)pce.getNewValue();
            this.getAction(FINISH).setEnabled(i > 0);
        }
    }
}

