/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.classifier.view;

import java.awt.Cursor;
import java.util.Set;
import org.openmicroscopy.shoola.agents.util.DataHandlerTranslator;
import org.openmicroscopy.shoola.agents.util.classifier.view.Classifier;
import org.openmicroscopy.shoola.agents.util.classifier.view.ClassifierControl;
import org.openmicroscopy.shoola.agents.util.classifier.view.ClassifierFactory;
import org.openmicroscopy.shoola.agents.util.classifier.view.ClassifierModel;
import org.openmicroscopy.shoola.agents.util.classifier.view.ClassifierView;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;

class ClassifierComponent
extends AbstractComponent
implements Classifier {
    private ClassifierModel model;
    private ClassifierControl controller;
    private ClassifierView view;

    ClassifierComponent(ClassifierModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = new ClassifierControl(this);
        this.view = new ClassifierView();
    }

    void initialize() {
        this.controller.initialize(this.view);
        this.view.initialize(this.model, this.controller);
    }

    public void activate() {
        switch (this.model.getState()) {
            case 1: {
                this.model.fireClassificationPathsLoading();
                this.fireStateChange();
                break;
            }
            case 2: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED state.");
            }
        }
    }

    public void discard() {
        this.model.discard();
        this.fireStateChange();
    }

    public void close() {
    }

    public void cancel() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        this.discard();
    }

    public void finish() {
        if (this.model.getState() != 3) {
            throw new IllegalStateException("This method can only be invoked in the READY state.");
        }
        Set categories = this.view.getSelectedPaths();
        if (categories == null || categories.size() == 0) {
            UserNotifier un = ClassifierFactory.getRegistry().getUserNotifier();
            un.notifyInfo("Categorisation", "No category selected.");
            return;
        }
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        this.view.finish();
        this.controller.getAction(ClassifierControl.FINISH).setEnabled(false);
        this.model.fireClassificationsSaving(categories);
        this.fireStateChange();
    }

    public int getState() {
        return this.model.getState();
    }

    public void saveClassifications(Set results) {
        if (this.model.getState() != 5) {
            throw new IllegalStateException("This method can only be invoked in the SAVING state.");
        }
        this.view.setCursor(Cursor.getPredefinedCursor(0));
        this.firePropertyChange("classified", null, results);
    }

    public void setClassifications(Set paths) {
        if (this.model.getState() != 4) {
            throw new IllegalStateException("This method can only be invoked in the LOADING state.");
        }
        if (paths == null) {
            throw new IllegalArgumentException("No classifications paths.");
        }
        long userID = this.model.getUserID();
        long groupID = this.model.getRootGroupID();
        Set nodes = DataHandlerTranslator.transformDataObjectsCheckNode(paths, userID, groupID);
        this.model.setClassificationPaths(nodes);
        this.view.showClassifications();
        this.fireStateChange();
    }
}

