/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.classifier;

import org.openmicroscopy.shoola.agents.util.classifier.view.Classifier;
import org.openmicroscopy.shoola.agents.util.classifier.view.ClassifierFactory;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.DSCallAdapter;
import org.openmicroscopy.shoola.env.data.views.DataHandlerView;

public abstract class ClassifierLoader
extends DSCallAdapter {
    protected final Classifier viewer;
    protected final Registry registry;
    protected final DataHandlerView dhView;

    protected void controlMode(int index) {
        switch (index) {
            case 0: 
            case 1: 
            case 2: {
                return;
            }
        }
        throw new IllegalArgumentException("Mode not supported.");
    }

    protected ClassifierLoader(Classifier viewer) {
        if (viewer == null) {
            throw new NullPointerException("No viewer.");
        }
        this.viewer = viewer;
        this.registry = ClassifierFactory.getRegistry();
        this.dhView = (DataHandlerView)this.registry.getDataServicesView(DataHandlerView.class);
    }

    public void onEnd() {
    }

    public void handleNullResult() {
        this.handleException(new Exception("No data available."));
    }

    public void handleCancellation() {
        String info = "The data retrieval has been cancelled.";
        this.registry.getLogger().info((Object)this, info);
        this.registry.getUserNotifier().notifyInfo("Data Retrieval Cancellation", info);
    }

    public void handleException(Throwable exc) {
        String s = "Data Retrieval Failure: ";
        this.registry.getLogger().error((Object)this, s + exc);
        this.registry.getUserNotifier().notifyError("Data Retrieval Failure", s, exc);
        this.viewer.cancel();
    }

    public abstract void load();

    public abstract void cancel();
}

