/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.classifier;

import java.util.Set;
import org.openmicroscopy.shoola.agents.util.classifier.ClassifierLoader;
import org.openmicroscopy.shoola.agents.util.classifier.view.Classifier;
import org.openmicroscopy.shoola.env.data.views.CallHandle;

public class ClassificationsSaver
extends ClassifierLoader {
    private int mode;
    private Set toClassify;
    private Set categories;
    private CallHandle handle;

    public ClassificationsSaver(Classifier viewer, Set toClassify, Set categories, int mode) {
        super(viewer);
        if (categories == null || categories.size() == 0) {
            throw new IllegalArgumentException("No category selected.");
        }
        if (toClassify == null || toClassify.size() == 0) {
            throw new IllegalArgumentException("No images to classify.");
        }
        this.controlMode(mode);
        this.mode = mode;
        this.toClassify = toClassify;
        this.categories = categories;
    }

    public void load() {
        switch (this.mode) {
            case 0: {
                this.handle = this.dhView.classify(this.toClassify, this.categories, this);
            }
            case 1: {
                this.handle = this.dhView.declassify(this.toClassify, this.categories, this);
            }
            case 2: {
                this.handle = this.dhView.classifyChildren(this.toClassify, this.categories, this);
            }
        }
    }

    public void cancel() {
        this.handle.cancel();
    }

    public void handleResult(Object result) {
        if (this.viewer.getState() == 2) {
            return;
        }
        this.viewer.saveClassifications((Set)result);
    }
}

