/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.classifier;

import java.util.Set;
import org.openmicroscopy.shoola.agents.util.classifier.ClassifierLoader;
import org.openmicroscopy.shoola.agents.util.classifier.view.Classifier;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import pojos.ExperimenterData;

public class ClassificationsLoader
extends ClassifierLoader {
    private int mode;
    private long rootID;
    private Set images;
    private CallHandle handle;

    public ClassificationsLoader(Classifier viewer, Set images, long rootID, int mode) {
        super(viewer);
        if (images == null || images.size() == 0) {
            throw new IllegalArgumentException("No images to classify.");
        }
        this.controlMode(mode);
        this.mode = mode;
        this.images = images;
        this.rootID = rootID;
    }

    public ClassificationsLoader(Classifier viewer, long rootID) {
        super(viewer);
        this.mode = 2;
        this.rootID = rootID;
        this.images = null;
    }

    public void load() {
        switch (this.mode) {
            case 0: 
            case 2: {
                this.handle = this.dhView.loadClassificationPaths(this.images, ExperimenterData.class, this.rootID, 2, this);
                break;
            }
            case 1: {
                this.handle = this.dhView.loadClassificationPaths(this.images, ExperimenterData.class, this.rootID, 0, this);
            }
        }
    }

    public void cancel() {
        this.handle.cancel();
    }

    public void handleResult(Object result) {
        if (this.viewer.getState() == 2) {
            return;
        }
        this.viewer.setClassifications((Set)result);
    }
}

