/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.archived.view;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openmicroscopy.shoola.agents.util.archived.view.Downloader;
import org.openmicroscopy.shoola.agents.util.archived.view.DownloaderControl;
import org.openmicroscopy.shoola.agents.util.archived.view.DownloaderFactory;
import org.openmicroscopy.shoola.agents.util.archived.view.DownloaderModel;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.FolderChooserDialog;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;

class DownloaderComponent
extends AbstractComponent
implements Downloader {
    private DownloaderModel model;
    private DownloaderControl controller;
    private FolderChooserDialog view;

    DownloaderComponent(DownloaderModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = new DownloaderControl(this);
    }

    void initialize() {
        this.view = new FolderChooserDialog(DownloaderFactory.getOwner());
        this.controller.initialize(this.view);
    }

    public void activate() {
        switch (this.model.getState()) {
            case 1: {
                if (this.view == null) break;
                UIUtilities.centerAndShow(this.view);
            }
        }
    }

    public void cancel() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        this.discard();
    }

    public void discard() {
        this.model.discard();
        this.fireStateChange();
    }

    public int getState() {
        return this.model.getState();
    }

    public void setArchivedFiles(Map files) {
        if (this.model.getState() != 4) {
            return;
        }
        this.model.setState(3);
        this.fireStateChange();
        UserNotifier un = DownloaderFactory.getRegistry().getUserNotifier();
        if (files == null || files.size() == 0) {
            un.notifyInfo("Download Archived files", "No archived file stored for the specified set of pixels.");
            return;
        }
        Iterator i = files.keySet().iterator();
        if (i.hasNext()) {
            String message;
            Integer original = (Integer)i.next();
            List unsaved = (List)files.get(original);
            if (unsaved == null || unsaved.size() == 0) {
                String f = "file has";
                int n = original;
                if (n > 1) {
                    f = f + "files have";
                }
                message = "The archived " + f + " been successfully downloaded.";
            } else {
                String f = "file was";
                int n = original;
                if (n > 1) {
                    f = f + "files were";
                }
                message = n + " archived " + f + " found but the " + "following couldn't be downloaded: \n";
                Iterator j = unsaved.iterator();
                int index = 0;
                n = unsaved.size() - 1;
                while (j.hasNext()) {
                    message = message + (String)j.next();
                    message = index != n ? message + "\n" : message + ".";
                    ++index;
                }
            }
            un.notifyInfo("Download Archived files", message);
        }
    }

    public void download(String location) {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        this.model.fireDownloadArchived(location);
        this.fireStateChange();
    }
}

