/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.annotator.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorControl;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorFactory;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorModel;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorUI;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorUtil;
import org.openmicroscopy.shoola.agents.util.annotator.view.StatusBar;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.DataObject;

class AnnotatorView
extends JDialog {
    private static final Dimension DEFAULT_SIZE = new Dimension(800, 500);
    private static final String TITLE = "Annotate";
    private static final String NOTE = "Annotate the selected items.";
    private static final String NOTE_CHILDREN = "Annotate the images contained in the selected folder.";
    private AnnotatorControl controller;
    private AnnotatorModel model;
    private StatusBar statusBar;
    private AnnotatorUI annotatorUI;

    private JPanel buildToolBar() {
        JPanel bar = new JPanel();
        bar.setBorder(null);
        JButton b = new JButton(this.controller.getAction(AnnotatorControl.FINISH));
        bar.add(b);
        this.getRootPane().setDefaultButton(b);
        bar.add(Box.createRigidArea(AnnotatorUtil.H_SPACER_SIZE));
        b = new JButton(this.controller.getAction(AnnotatorControl.CANCEL));
        bar.add(b);
        return UIUtilities.buildComponentPanelRight(bar);
    }

    private JPanel buildBody() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.add(this.annotatorUI);
        p.add(new JSeparator());
        p.add(this.buildToolBar());
        return p;
    }

    private void buildGUI() {
        IconManager icons = IconManager.getInstance();
        String note = NOTE;
        if (this.model.getAnnotationMode() == 1) {
            note = NOTE_CHILDREN;
        }
        TitlePanel tp = new TitlePanel(TITLE, note, icons.getIcon(17));
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout(0, 0));
        c.add((Component)tp, "North");
        c.add((Component)this.buildBody(), "Center");
        c.add((Component)this.statusBar, "South");
    }

    private void setProperties() {
        this.setModal(true);
        this.setTitle(TITLE);
    }

    AnnotatorView() {
        super(AnnotatorFactory.getOwner());
        this.setProperties();
    }

    void initialize(AnnotatorModel model, AnnotatorControl controller) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        this.controller = controller;
        this.model = model;
        this.statusBar = new StatusBar();
        this.annotatorUI = new AnnotatorUI(model, controller);
        this.buildGUI();
    }

    void showAnnotations() {
        this.annotatorUI.showAnnotations();
    }

    void setStatus(String text, boolean hide) {
        this.statusBar.setStatus(text);
        this.statusBar.setProgress(hide);
    }

    String getAnnotationText() {
        return this.annotatorUI.getAnnotationText();
    }

    boolean hasDataToSave() {
        return this.annotatorUI.hasDataToSave();
    }

    String getSelectedObjectName() {
        return this.annotatorUI.getSelectedObjectName();
    }

    void setOnScreen() {
        this.setSize(DEFAULT_SIZE);
        UIUtilities.centerAndShow(this);
    }

    DataObject getSelectedDataObject() {
        return this.annotatorUI.getSelectedDataObject();
    }
}

