/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.annotator.view;

import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JTree;
import javax.swing.border.CompoundBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.openmicroscopy.shoola.agents.util.annotator.view.EditorTreeCellRenderer;
import org.openmicroscopy.shoola.util.ui.MultilineLabel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.border.TitledLineBorder;
import pojos.AnnotationData;

class AnnotatorUtil {
    static final Dimension SMALL_V_SPACER_SIZE = new Dimension(1, 6);
    static final Dimension SMALL_H_SPACER_SIZE = new Dimension(6, 1);
    static final Dimension AREA_SIZE = new Dimension(200, 150);
    static final String COMMENT_TITLE = "Total: ";
    static final String COMMENT = " annotation";
    static final String NEW_ANNOTATION = "New annotation";
    static final String BULK_TEXT = "Enter the textual annotation.";
    static final Dimension H_SPACER_SIZE = new Dimension(5, 10);
    static final int ROWS = 10;

    AnnotatorUtil() {
    }

    static void sortAnnotationByDate(List annotations) {
        if (annotations == null || annotations.size() == 0) {
            return;
        }
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                Timestamp t1 = ((AnnotationData)o1).getLastModified();
                Timestamp t2 = ((AnnotationData)o2).getLastModified();
                long n1 = t1.getTime();
                long n2 = t2.getTime();
                int v = 0;
                if (n1 < n2) {
                    v = -1;
                } else if (n1 > n2) {
                    v = 1;
                }
                return -v;
            }
        };
        Collections.sort(annotations, c);
    }

    static void setAnnotationAreaDefault(MultilineLabel area, String title) {
        CompoundBorder border = BorderFactory.createCompoundBorder(new TitledLineBorder(title), BorderFactory.createBevelBorder(1));
        area.setBorder(border);
        area.setOriginalBackground(UIUtilities.BACKGROUND);
        area.setOpaque(true);
        area.setEditable(true);
        area.setPreferredSize(AREA_SIZE);
    }

    static JTree initTree() {
        JTree treeDisplay = new JTree();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("");
        treeDisplay.setModel(new DefaultTreeModel(root));
        treeDisplay.setRootVisible(false);
        treeDisplay.setVisible(true);
        treeDisplay.setShowsRootHandles(true);
        treeDisplay.getSelectionModel().setSelectionMode(1);
        treeDisplay.setCellRenderer(new EditorTreeCellRenderer());
        return treeDisplay;
    }

    static String getPartialName(String originalName) {
        if (Pattern.compile("/").matcher(originalName).find()) {
            String[] l = originalName.split("/", 0);
            int n = l.length;
            if (n == 1) {
                return l[0];
            }
            return "..." + l[n - 2] + "/" + l[n - 1];
        }
        if (Pattern.compile("\\\\").matcher(originalName).find()) {
            String[] l = originalName.split("\\\\", 0);
            int n = l.length;
            if (n == 1) {
                return l[0];
            }
            return "..." + l[n - 2] + "\\" + l[n - 1];
        }
        return originalName;
    }
}

