/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.annotator.view;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import layout.TableLayout;
import org.openmicroscopy.shoola.agents.util.annotator.actions.FinishAction;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotateNode;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorControl;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorModel;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorUtil;
import org.openmicroscopy.shoola.agents.util.annotator.view.EditorTreeCellRenderer;
import org.openmicroscopy.shoola.agents.util.annotator.view.OwnerNode;
import org.openmicroscopy.shoola.agents.util.annotator.view.TimeNode;
import org.openmicroscopy.shoola.util.ui.MultilineLabel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.border.TitledLineBorder;
import pojos.AnnotationData;
import pojos.DataObject;
import pojos.ExperimenterData;

class AnnotatorUI
extends JPanel {
    private MultilineLabel annotationArea;
    private long selectedOwnerID;
    private AnnotateNode selectedNode;
    private JTree ownerTree;
    private AnnotatorModel model;
    private AnnotatorControl controller;
    private Map<Long, List> areas;
    private JPanel listAnnotations;
    private JScrollPane scrollAnnotations;
    private boolean init;
    private JLabel commentLabel;
    private DocumentListener listener;
    private JTree objectsTree;

    private void handleNodeSelection() {
        Object o = this.ownerTree.getLastSelectedPathComponent();
        if (o instanceof OwnerNode) {
            long ownerID = ((OwnerNode)o).getOwnerID();
            this.showSingleAnnotation(ownerID);
            this.selectedOwnerID = ownerID;
        } else if (o instanceof TimeNode) {
            TimeNode tm = (TimeNode)o;
            long ownerID = tm.getOwnerID();
            if (ownerID != this.selectedOwnerID) {
                this.showSingleAnnotation(ownerID);
            }
            this.selectedOwnerID = ownerID;
            this.showDateAnnotation(ownerID, tm.getIndex());
        }
        this.validate();
        this.repaint();
    }

    private void handleAnnotateNodeSelection() {
        AnnotateNode node;
        this.selectedNode = node = (AnnotateNode)this.objectsTree.getLastSelectedPathComponent();
        this.showObjectAnnotation(this.selectedNode);
        this.validate();
        this.repaint();
    }

    private void scrollToNode(JComponent c) {
        if (c == null) {
            return;
        }
        this.init = true;
        Rectangle bounds = c.getBounds();
        Rectangle viewRect = this.scrollAnnotations.getViewport().getViewRect();
        if (!viewRect.contains(bounds)) {
            int x = 0;
            int y = 0;
            int w = viewRect.width - bounds.width;
            if (w < 0) {
                w = -w;
            }
            x = bounds.x - w / 2;
            int h = viewRect.height - bounds.height;
            if (h < 0) {
                h = -h;
            }
            y = bounds.y - h / 2;
            JScrollBar hBar = this.scrollAnnotations.getHorizontalScrollBar();
            JScrollBar vBar = this.scrollAnnotations.getVerticalScrollBar();
            vBar.setValue(y);
            hBar.setValue(x);
        }
        if (c == this.annotationArea) {
            c.setVisible(true);
            c.requestFocus();
        }
    }

    private void handleAnnotationAreaInsert() {
        FinishAction action = (FinishAction)this.controller.getAction(AnnotatorControl.FINISH);
        action.setEnabled(this.hasDataToSave());
    }

    private void initComponents() {
        this.commentLabel = new JLabel("0  annotation");
        this.listAnnotations = new JPanel();
        this.listAnnotations.setLayout(new BoxLayout(this.listAnnotations, 1));
        this.scrollAnnotations = new JScrollPane(this.listAnnotations);
        JScrollBar vBar = this.scrollAnnotations.getVerticalScrollBar();
        vBar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (!e.getValueIsAdjusting() && !AnnotatorUI.this.init) {
                    JScrollBar vBar = AnnotatorUI.this.scrollAnnotations.getVerticalScrollBar();
                    vBar.setValue(0);
                } else if (e.getValueIsAdjusting()) {
                    AnnotatorUI.this.init = true;
                }
            }
        });
        this.ownerTree = AnnotatorUtil.initTree();
        this.ownerTree.setCellRenderer(new EditorTreeCellRenderer());
        this.ownerTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                AnnotatorUI.this.handleNodeSelection();
            }
        });
        this.ownerTree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent e) {
                AnnotatorUI.this.ownerTree.setSelectionPath(new TreePath(e.getPath().getLastPathComponent()));
            }

            public void treeExpanded(TreeExpansionEvent e) {
                AnnotatorUI.this.ownerTree.setSelectionPath(new TreePath(e.getPath().getLastPathComponent()));
            }
        });
        this.objectsTree = AnnotatorUtil.initTree();
        this.objectsTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                AnnotatorUI.this.handleAnnotateNodeSelection();
            }
        });
        this.objectsTree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent e) {
                AnnotatorUI.this.objectsTree.setSelectionPath(new TreePath(e.getPath().getLastPathComponent()));
            }

            public void treeExpanded(TreeExpansionEvent e) {
                AnnotatorUI.this.objectsTree.setSelectionPath(new TreePath(e.getPath().getLastPathComponent()));
            }
        });
        this.annotationArea = new MultilineLabel();
        this.annotationArea.setBorder(BorderFactory.createEtchedBorder());
        this.annotationArea.setRows(10);
        this.listener = new DocumentListener(){

            public void insertUpdate(DocumentEvent de) {
                AnnotatorUI.this.handleAnnotationAreaInsert();
            }

            public void removeUpdate(DocumentEvent de) {
                AnnotatorUI.this.handleAnnotationAreaInsert();
            }

            public void changedUpdate(DocumentEvent de) {
            }
        };
        this.annotationArea.getDocument().addDocumentListener(this.listener);
        this.handleAnnotationAreaInsert();
    }

    private JComponent buildAnnotationPanel() {
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        if (this.model.getAnnotationMode() == 1) {
            double[][] tl = new double[][]{{-1.0}, {-1.0}};
            p.setLayout((LayoutManager)new TableLayout((double[][])tl));
            AnnotatorUtil.setAnnotationAreaDefault(this.annotationArea, "New annotation");
            p.add((Component)this.annotationArea, "0, 0");
            this.commentLabel.setText("Enter the textual annotation.");
        } else {
            JPanel empty = new JPanel();
            empty.setOpaque(true);
            double[][] tl = new double[][]{{250.0, 5.0, 250.0, 5.0, -1.0}, {0.0, -1.0}};
            p.setLayout((LayoutManager)new TableLayout((double[][])tl));
            p.add((Component)new JScrollPane(this.objectsTree), "0, 0, 0, 1");
            p.add((Component)empty, "1, 0, f, t");
            p.add((Component)new JScrollPane(this.ownerTree), "2, 0, 0, 1");
            p.add((Component)empty, "3, 0, f, t");
            p.add((Component)this.scrollAnnotations, "4, 0, 4, 1");
        }
        return p;
    }

    private void buildGUI() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        p.add(this.commentLabel);
        this.add(UIUtilities.buildComponentPanel(p));
        this.add(new JSeparator());
        this.add(Box.createRigidArea(AnnotatorUtil.SMALL_V_SPACER_SIZE));
        this.add(this.buildAnnotationPanel());
    }

    private void showSingleAnnotation(long ownerID) {
        this.listAnnotations.removeAll();
        List l = this.areas.get(new Long(ownerID));
        for (MultilineLabel c : l) {
            if (c != this.annotationArea) {
                c.setBackground(c.getOriginalBackground());
                this.listAnnotations.add(c);
                continue;
            }
            JScrollPane pane = new JScrollPane(c);
            pane.getVerticalScrollBar().setVisible(true);
            this.listAnnotations.add(pane);
        }
    }

    private void showDateAnnotation(long ownerID, int index) {
        MultilineLabel c;
        List l = this.areas.get(new Long(ownerID));
        int j = index;
        long userID = this.model.getUserDetails().getId();
        if (ownerID == userID) {
            ++j;
        }
        for (int i = 0; i < l.size(); ++i) {
            c = (MultilineLabel)l.get(i);
            c.setBackground(c.getOriginalBackground());
            if (j != i || c == this.annotationArea) continue;
            c.setBackground(UIUtilities.HIGHLIGHT);
        }
        c = (MultilineLabel)l.get(j);
        this.scrollToNode(c);
    }

    private void showObjectAnnotation(AnnotateNode node) {
        long objectID = node.getUserObjectID();
        DefaultTreeModel dtm = (DefaultTreeModel)this.ownerTree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)dtm.getRoot();
        root.removeAllChildren();
        dtm.reload(root);
        this.listAnnotations.removeAll();
        this.areas.clear();
        ExperimenterData userDetails = this.model.getUserDetails();
        if (userDetails == null) {
            return;
        }
        Map annotations = null;
        annotations = this.model.getAnnotationsFor(objectID);
        DefaultMutableTreeNode currentUser = null;
        int number = 0;
        if (annotations != null) {
            Iterator i = annotations.keySet().iterator();
            int index = 0;
            while (i.hasNext()) {
                Long id = (Long)i.next();
                List list = (List)annotations.get(id);
                number += list.size();
                ExperimenterData data = ((AnnotationData)list.get(0)).getOwner();
                OwnerNode owner = new OwnerNode(data);
                owner.setNumberOfAnnotations(list.size());
                dtm.insertNodeInto(owner, root, root.getChildCount());
                this.buildTreeNode(owner, list, dtm);
                if (userDetails.getId() == (long)id.intValue()) {
                    currentUser = owner;
                }
                ++index;
            }
        }
        if (currentUser == null) {
            currentUser = new OwnerNode(userDetails);
            dtm.insertNodeInto(currentUser, root, root.getChildCount());
            this.buildTreeNode((OwnerNode)currentUser, null, dtm);
        }
        TreePath path = new TreePath(currentUser.getPath());
        this.ownerTree.setSelectionPath(path);
        this.ownerTree.expandPath(path);
        String text = number + " annotation";
        if (number > 1) {
            text = text + "s";
        }
        text = text + " for " + node.getObjectName();
        this.commentLabel.setText(text);
    }

    private void buildTreeNode(OwnerNode parent, List annotations, DefaultTreeModel dtm) {
        ArrayList<MultilineLabel> l;
        long ownerID = parent.getOwnerID();
        Long id = new Long(ownerID);
        boolean user = this.model.getUserDetails().getId() == ownerID;
        TimeNode node = new TimeNode(ownerID, -1, null);
        if (user) {
            dtm.insertNodeInto(node, parent, parent.getChildCount());
            AnnotatorUtil.setAnnotationAreaDefault(this.annotationArea, node.toString());
        }
        if ((annotations == null || annotations.size() == 0) && user) {
            ArrayList<MultilineLabel> l2 = new ArrayList<MultilineLabel>(1);
            l2.add(this.annotationArea);
            this.areas.put(id, l2);
            return;
        }
        int row = 0;
        if (user) {
            l = new ArrayList(annotations.size() + 1);
            l.add(this.annotationArea);
            row = 1;
        } else {
            l = new ArrayList<MultilineLabel>(annotations.size());
        }
        Iterator i = annotations.iterator();
        int index = 0;
        while (i.hasNext()) {
            AnnotationData data = (AnnotationData)i.next();
            Timestamp date = data.getLastModified();
            if (date == null) {
                date = new Timestamp(new Date().getTime());
            }
            node = new TimeNode(ownerID, index, date);
            data = (AnnotationData)annotations.get(index);
            dtm.insertNodeInto(node, parent, parent.getChildCount());
            MultilineLabel area = new MultilineLabel();
            area.setEditable(false);
            area.setOpaque(true);
            area.setBorder(new TitledLineBorder(node.toString()));
            area.setText(data.getText());
            if (index % 2 == row) {
                area.setOriginalBackground(UIUtilities.BACKGROUND);
            } else {
                area.setOriginalBackground(UIUtilities.BACKGROUND_ONE);
            }
            l.add(area);
            ++index;
        }
        this.areas.put(id, l);
    }

    private void buildImageTree(DefaultMutableTreeNode parent, Set nodes, DefaultTreeModel dtm) {
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            AnnotateNode node = new AnnotateNode(i.next());
            if (this.selectedNode == null) {
                this.selectedNode = node;
            }
            dtm.insertNodeInto(node, parent, parent.getChildCount());
        }
    }

    AnnotatorUI(AnnotatorModel model, AnnotatorControl controller) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        this.model = model;
        this.controller = controller;
        this.areas = new HashMap<Long, List>();
        this.selectedOwnerID = -1L;
        this.selectedNode = null;
        this.initComponents();
        this.buildGUI();
    }

    void showAnnotations() {
        DefaultTreeModel dtm = (DefaultTreeModel)this.objectsTree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)dtm.getRoot();
        root.removeAllChildren();
        this.buildImageTree(root, this.model.getSelectedObjects(), dtm);
        dtm.reload(root);
        if (this.selectedNode != null) {
            this.showObjectAnnotation(this.selectedNode);
            this.objectsTree.setSelectionPath(new TreePath(this.selectedNode.getPath()));
        }
    }

    String getAnnotationText() {
        String s = this.annotationArea.getText();
        if (s == null) {
            return "";
        }
        return s.trim();
    }

    boolean hasDataToSave() {
        return this.getAnnotationText().length() != 0;
    }

    String getSelectedObjectName() {
        if (this.selectedNode == null) {
            return "";
        }
        return this.selectedNode.toString();
    }

    DataObject getSelectedDataObject() {
        if (this.selectedNode == null) {
            return null;
        }
        Object uo = this.selectedNode.getUserObject();
        if (uo instanceof DataObject) {
            return (DataObject)uo;
        }
        return null;
    }
}

