/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.annotator.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import layout.TableLayout;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class AnnotatorSavingDialog
extends JDialog
implements ActionListener {
    static final int ANNOTATOR = 0;
    static final int ANNOTATOR_EDITOR = 1;
    static final String ANNOTATE_ALL_PROPERTY = "annotateAll";
    static final String ANNOTATE_ONE_PROPERTY = "annotateOne";
    private static final String TITLE = "Save annotation";
    private static final String TEXT_START = "Do you want to apply this annotation only to ";
    private static final String TEXT_ANNOTATOR_END = " or to all items in the annotation list?";
    private static final String TEXT_ANNOTATOR_EDITOR_END = " or to all selected items?";
    private static final Dimension DEFAULT_SIZE = new Dimension(400, 200);
    private static final int ALL_ID = 0;
    private static final int ONE_ID = 1;
    private static final int CANCEL_ID = 2;
    private int index;
    private String text;
    private JButton allButton;
    private JButton oneButton;
    private JButton cancelButton;

    private void setProperties() {
        this.setModal(true);
        this.setTitle(TITLE);
        this.setDefaultCloseOperation(0);
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void checkIndex(int i) {
        switch (i) {
            case 0: 
            case 1: {
                return;
            }
        }
        throw new IllegalArgumentException("Index not supported.");
    }

    private void initComponents(String s) {
        this.allButton = new JButton("All");
        this.allButton.setActionCommand("0");
        this.allButton.addActionListener(this);
        this.oneButton = new JButton("One");
        this.oneButton.setActionCommand("1");
        this.oneButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setActionCommand("2");
        this.cancelButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.allButton);
        this.text = TEXT_START + s;
        this.text = this.index == 0 ? this.text + TEXT_ANNOTATOR_END : this.text + TEXT_ANNOTATOR_EDITOR_END;
    }

    private JPanel buildBody() {
        IconManager icons = IconManager.getInstance();
        Icon icon = icons.getIcon(17);
        JPanel commentPanel = new JPanel();
        int iconSpace = 0;
        int iconHeight = 0;
        if (icon != null) {
            iconSpace = icon.getIconWidth() + 20;
            iconHeight = icon.getIconHeight() + 10;
        }
        double[][] tableSize = new double[][]{{iconSpace, 160 - iconSpace, -1.0}, {iconHeight, -1.0}};
        TableLayout layout = new TableLayout((double[][])tableSize);
        commentPanel.setLayout((LayoutManager)layout);
        commentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        if (icon != null) {
            commentPanel.add((Component)new JLabel(icon), "0, 0");
        }
        commentPanel.add((Component)UIUtilities.buildTextPane(this.text), "1, 0, 2, 1");
        return commentPanel;
    }

    private void buildGUI() {
        JPanel mainPanel = new JPanel();
        mainPanel.setOpaque(false);
        double[][] tableSize = new double[][]{{-1.0, 100.0, 5.0, 100.0, 5.0, 100.0, 5.0}, {-1.0, 40.0}};
        TableLayout layout = new TableLayout((double[][])tableSize);
        mainPanel.setLayout((LayoutManager)layout);
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mainPanel.add((Component)this.buildBody(), "0, 0, 6, 0");
        mainPanel.add((Component)this.allButton, "1, 1, f, c");
        mainPanel.add((Component)this.oneButton, "3, 1, f, c");
        mainPanel.add((Component)this.cancelButton, "5, 1, f, c");
        this.getContentPane().add((Component)mainPanel, "Center");
    }

    private void initialize(int index, String name) {
        this.checkIndex(index);
        this.setProperties();
        this.index = index;
        this.initComponents(name);
        this.buildGUI();
        this.setSize(DEFAULT_SIZE);
    }

    AnnotatorSavingDialog(JDialog owner, int index, String name) {
        super(owner);
        this.initialize(index, name);
    }

    AnnotatorSavingDialog(JFrame owner, int index, String name) {
        super(owner);
        this.initialize(index, name);
    }

    public void actionPerformed(ActionEvent e) {
        int index = -1;
        try {
            index = Integer.parseInt(e.getActionCommand());
            switch (index) {
                case 2: {
                    this.close();
                    break;
                }
                case 1: {
                    this.firePropertyChange(ANNOTATE_ONE_PROPERTY, Boolean.FALSE, Boolean.TRUE);
                    this.close();
                    break;
                }
                case 0: {
                    this.firePropertyChange(ANNOTATE_ALL_PROPERTY, Boolean.FALSE, Boolean.TRUE);
                    this.close();
                }
            }
        }
        catch (NumberFormatException nfe) {
            throw new Error("Invalid Action ID " + index, nfe);
        }
    }
}

