/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.annotator.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.agents.util.annotator.AnnotationsLoader;
import org.openmicroscopy.shoola.agents.util.annotator.AnnotationsSaver;
import org.openmicroscopy.shoola.agents.util.annotator.AnnotatorLoader;
import org.openmicroscopy.shoola.agents.util.annotator.view.Annotator;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorFactory;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorUtil;
import pojos.AnnotationData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.ImageData;

class AnnotatorModel {
    private int mode;
    private int state;
    private Set<DataObject> toAnnotate;
    private Set<DataObject> annotated;
    private Class type;
    private Map annotations;
    private AnnotatorLoader currentLoader;
    protected Annotator component;

    private boolean isObjectAnnotated(DataObject data) {
        Long n = null;
        if (data instanceof ImageData) {
            n = ((ImageData)data).getAnnotationCount();
        } else if (data instanceof DatasetData) {
            n = ((DatasetData)data).getAnnotationCount();
        }
        if (n == null) {
            return false;
        }
        return n != 0L;
    }

    private void checkMode(int m) {
        switch (m) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Annotate mode not supported.");
            }
        }
    }

    AnnotatorModel(Set objects, int mode, Class type) {
        this.checkMode(mode);
        this.mode = mode;
        this.toAnnotate = objects;
        if (mode == 0) {
            this.annotated = new HashSet<DataObject>();
            for (DataObject data : objects) {
                if (!this.isObjectAnnotated(data)) continue;
                this.annotated.add(data);
            }
        }
        this.state = 1;
        this.type = type;
    }

    void initialize(Annotator component) {
        this.component = component;
    }

    int getState() {
        return this.state;
    }

    void discard() {
        this.cancel();
        this.state = 2;
    }

    void cancel() {
        if (this.currentLoader != null) {
            this.currentLoader.cancel();
            this.currentLoader = null;
        }
        this.state = 3;
    }

    void fireAnnotationsRetrieval() {
        if (this.mode == 1 || this.annotated.size() == 0) {
            this.state = 3;
            return;
        }
        this.currentLoader = new AnnotationsLoader(this.component, this.annotated, this.type);
        this.currentLoader.load();
        this.state = 4;
    }

    void fireAnnotationSaving(AnnotationData data, DataObject object) {
        switch (this.mode) {
            case 0: {
                if (object == null) {
                    this.currentLoader = new AnnotationsSaver(this.component, this.toAnnotate, data, this.mode);
                    break;
                }
                HashSet<DataObject> nodes = new HashSet<DataObject>(1);
                nodes.add(object);
                this.currentLoader = new AnnotationsSaver(this.component, nodes, data, this.mode);
                break;
            }
            case 1: {
                this.currentLoader = new AnnotationsSaver(this.component, this.toAnnotate, data, this.mode);
            }
        }
        this.currentLoader.load();
        this.state = 5;
    }

    void setAnnotations(Map map) {
        HashMap objectAnnotations = new HashMap();
        for (Long index : map.keySet()) {
            Set set = (Set)map.get(index);
            Iterator<Object> j = set.iterator();
            HashMap<Long, ArrayList<AnnotationData>> sortedAnnotations = new HashMap<Long, ArrayList<AnnotationData>>();
            while (j.hasNext()) {
                AnnotationData annotation = (AnnotationData)j.next();
                Long ownerID = new Long(annotation.getOwner().getId());
                ArrayList<AnnotationData> userAnnos = (ArrayList<AnnotationData>)sortedAnnotations.get(ownerID);
                if (userAnnos == null) {
                    userAnnos = new ArrayList<AnnotationData>();
                    sortedAnnotations.put(ownerID, userAnnos);
                }
                userAnnos.add(annotation);
            }
            for (Long ownerID : sortedAnnotations.keySet()) {
                List annotations = (List)sortedAnnotations.get(ownerID);
                AnnotatorUtil.sortAnnotationByDate(annotations);
            }
            objectAnnotations.put(index, sortedAnnotations);
        }
        this.annotations = objectAnnotations;
        this.state = 3;
    }

    Map getAnnotationsFor(long annotateID) {
        return (Map)this.annotations.get(new Long(annotateID));
    }

    AnnotationData getAnnotationType() {
        if (this.mode == 1) {
            return new AnnotationData(0);
        }
        if (this.type.equals(DatasetData.class)) {
            return new AnnotationData(1);
        }
        if (this.type.equals(ImageData.class)) {
            return new AnnotationData(0);
        }
        return null;
    }

    int getAnnotationMode() {
        return this.mode;
    }

    ExperimenterData getUserDetails() {
        return (ExperimenterData)AnnotatorFactory.getRegistry().lookup("/current_user/details");
    }

    Set getSelectedObjects() {
        return this.toAnnotate;
    }
}

