/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.annotator.view;

import java.util.Set;
import javax.swing.JFrame;
import org.openmicroscopy.shoola.agents.util.annotator.view.Annotator;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorComponent;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorEditor;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorEditorComponent;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorEditorModel;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorModel;
import org.openmicroscopy.shoola.env.config.Registry;
import pojos.DataObject;

public class AnnotatorFactory {
    private static final AnnotatorFactory singleton = new AnnotatorFactory();
    private static Registry registry;
    private static JFrame owner;

    public static AnnotatorEditor getEditor(Registry ctx, DataObject object, int layout) {
        if (registry == null) {
            registry = ctx;
        }
        return singleton.createEditor(object, layout);
    }

    public static Annotator getAnnotator(JFrame parent, Set objects, Registry ctx, Class type) {
        if (registry == null) {
            registry = ctx;
        }
        if (parent == null) {
            owner = parent;
        }
        if (objects == null || objects.size() == 0) {
            return null;
        }
        return singleton.createAnnotator(objects, 0, type);
    }

    public static Annotator getChildrenAnnotator(JFrame parent, Set objects, Registry ctx, Class type) {
        if (registry == null) {
            registry = ctx;
        }
        if (parent == null) {
            owner = parent;
        }
        if (objects == null || objects.size() == 0) {
            return null;
        }
        return singleton.createAnnotator(objects, 1, type);
    }

    public static Registry getRegistry() {
        return registry;
    }

    public static JFrame getOwner() {
        return owner;
    }

    private AnnotatorFactory() {
    }

    private Annotator createAnnotator(Set objects, int mode, Class type) {
        AnnotatorModel model = new AnnotatorModel(objects, mode, type);
        AnnotatorComponent component = new AnnotatorComponent(model);
        model.initialize(component);
        component.initialize();
        return component;
    }

    private AnnotatorEditor createEditor(DataObject object, int layout) {
        AnnotatorEditorModel model = new AnnotatorEditorModel(object);
        AnnotatorEditorComponent component = new AnnotatorEditorComponent(model, layout);
        model.initialize(component);
        component.initialize();
        return component;
    }
}

