/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.annotator.view;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import layout.TableLayout;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorEditorControl;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorEditorModel;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorUtil;
import org.openmicroscopy.shoola.agents.util.annotator.view.EditorTreeCellRenderer;
import org.openmicroscopy.shoola.agents.util.annotator.view.OwnerNode;
import org.openmicroscopy.shoola.agents.util.annotator.view.TimeNode;
import org.openmicroscopy.shoola.util.ui.MultilineLabel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.border.TitledLineBorder;
import pojos.AnnotationData;
import pojos.ExperimenterData;

class AnnotatorEditorView
extends JPanel {
    private JButton saveButton;
    private JButton clearButton;
    private MultilineLabel annotationArea;
    private JButton deleteButton;
    private JPanel pane;
    private int layout;
    private long selectedOwnerID;
    private JTree treeDisplay;
    private AnnotatorEditorModel model;
    private AnnotatorEditorControl controller;
    private Map<Long, List> areas;
    private JPanel listAnnotations;
    private JScrollPane scrollAnnotations;
    private boolean init;
    private JLabel commentLabel;
    private DocumentListener listener;
    private AdjustmentListener adjustementlistener;

    private void handleNodeSelection() {
        Object o = this.treeDisplay.getLastSelectedPathComponent();
        if (o instanceof OwnerNode) {
            long ownerID = ((OwnerNode)o).getOwnerID();
            this.showSingleAnnotation(ownerID);
            this.selectedOwnerID = ownerID;
        } else if (o instanceof TimeNode) {
            TimeNode tm = (TimeNode)o;
            long ownerID = tm.getOwnerID();
            if (ownerID != this.selectedOwnerID) {
                this.showSingleAnnotation(ownerID);
            }
            this.selectedOwnerID = ownerID;
            this.showDateAnnotation(ownerID, tm.getIndex());
        }
        this.validate();
        this.repaint();
    }

    private void scrollToNode(JComponent c) {
        if (c == null) {
            return;
        }
        Rectangle bounds = c.getBounds();
        Rectangle viewRect = this.scrollAnnotations.getViewport().getViewRect();
        if (!viewRect.contains(bounds)) {
            int x = 0;
            int y = 0;
            int w = viewRect.width - bounds.width;
            if (w < 0) {
                w = -w;
            }
            x = bounds.x - w / 2;
            int h = viewRect.height - bounds.height;
            if (h < 0) {
                h = -h;
            }
            y = bounds.y - h / 2;
            JScrollBar hBar = this.scrollAnnotations.getHorizontalScrollBar();
            JScrollBar vBar = this.scrollAnnotations.getVerticalScrollBar();
            vBar.removeAdjustmentListener(this.adjustementlistener);
            vBar.setValue(y);
            vBar.addAdjustmentListener(this.adjustementlistener);
            hBar.setValue(x);
        }
        if (c == this.annotationArea) {
            c.setVisible(true);
            c.requestFocus();
        }
    }

    private void initComponents() {
        this.commentLabel = new JLabel();
        this.listAnnotations = new JPanel();
        this.listAnnotations.setLayout(new BoxLayout(this.listAnnotations, 1));
        this.scrollAnnotations = new JScrollPane(this.listAnnotations);
        JScrollBar vBar = this.scrollAnnotations.getVerticalScrollBar();
        this.adjustementlistener = new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e) {
                if (!e.getValueIsAdjusting() && !AnnotatorEditorView.this.init) {
                    JScrollBar vBar = AnnotatorEditorView.this.scrollAnnotations.getVerticalScrollBar();
                    vBar.setValue(0);
                } else if (e.getValueIsAdjusting()) {
                    AnnotatorEditorView.this.init = true;
                }
            }
        };
        vBar.addAdjustmentListener(this.adjustementlistener);
        this.treeDisplay = AnnotatorUtil.initTree();
        this.treeDisplay.getSelectionModel().setSelectionMode(4);
        this.treeDisplay.setCellRenderer(new EditorTreeCellRenderer());
        this.treeDisplay.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                AnnotatorEditorView.this.handleNodeSelection();
            }
        });
        this.treeDisplay.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent e) {
                AnnotatorEditorView.this.treeDisplay.setSelectionPath(new TreePath(e.getPath().getLastPathComponent()));
            }

            public void treeExpanded(TreeExpansionEvent e) {
                AnnotatorEditorView.this.treeDisplay.setSelectionPath(new TreePath(e.getPath().getLastPathComponent()));
            }
        });
        this.saveButton = new JButton(this.controller.getAction(AnnotatorEditorControl.SAVE));
        this.clearButton = new JButton("Clear");
        this.clearButton.setToolTipText("Clear the annotation text.");
        this.clearButton.setEnabled(false);
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AnnotatorEditorView.this.clear();
            }
        });
        this.annotationArea = new MultilineLabel();
        this.annotationArea.setBorder(BorderFactory.createEtchedBorder());
        this.annotationArea.setRows(10);
        this.deleteButton = new JButton(this.controller.getAction(AnnotatorEditorControl.DELETE));
        this.listener = new DocumentListener(){

            public void insertUpdate(DocumentEvent de) {
                AnnotatorEditorView.this.model.setAnnotated(true);
                AnnotatorEditorView.this.saveButton.setEnabled(true);
                AnnotatorEditorView.this.clearButton.setEnabled(true);
            }

            public void removeUpdate(DocumentEvent de) {
                AnnotatorEditorView.this.model.setAnnotated(true);
            }

            public void changedUpdate(DocumentEvent de) {
            }
        };
        this.annotationArea.getDocument().addDocumentListener(this.listener);
    }

    private void clear() {
        this.annotationArea.setText("");
    }

    private JPanel buildAnnotationPanel() {
        JPanel p = new JPanel();
        JPanel empty = new JPanel();
        empty.setOpaque(true);
        switch (this.layout) {
            default: {
                double[][] tl = new double[][]{{-2.0, 5.0, -1.0, 5.0}, {-1.0}};
                p.setLayout((LayoutManager)new TableLayout((double[][])tl));
                p.add((Component)new JScrollPane(this.treeDisplay), "0, 0");
                p.add((Component)empty, "1, 0");
                p.add((Component)this.scrollAnnotations, "2, 0");
                empty = new JPanel();
                empty.setOpaque(true);
                p.add((Component)empty, "3, 0");
                break;
            }
            case 1: {
                double[][] tl2 = new double[][]{{450.0}, {200.0, 5.0, 300.0}};
                p.setLayout((LayoutManager)new TableLayout((double[][])tl2));
                p.add((Component)new JScrollPane(this.treeDisplay), "0, 0");
                p.add((Component)empty, "0, 1");
                p.add((Component)this.scrollAnnotations, "0, 2");
            }
        }
        return p;
    }

    private JPanel buildToolBar() {
        JPanel p = new JPanel();
        p.add(this.deleteButton);
        p.add(Box.createRigidArea(AnnotatorUtil.SMALL_H_SPACER_SIZE));
        p.add(this.clearButton);
        p.add(Box.createRigidArea(AnnotatorUtil.SMALL_H_SPACER_SIZE));
        p.add(this.saveButton);
        p.setOpaque(true);
        JPanel bar = new JPanel();
        double[][] tl = new double[][]{{-2.0, -1.0, -2.0}, {-2.0}};
        bar.setLayout((LayoutManager)new TableLayout((double[][])tl));
        bar.add((Component)UIUtilities.buildComponentPanel(this.commentLabel), "0, 0");
        bar.add((Component)UIUtilities.buildComponentPanelRight(p), "2, 0");
        return bar;
    }

    private void buildGUI() {
        this.setLayout(new BoxLayout(this, 1));
        this.pane = this.buildAnnotationPanel();
        this.add(this.pane);
        this.add(Box.createRigidArea(AnnotatorUtil.SMALL_V_SPACER_SIZE));
        this.add(this.buildToolBar());
    }

    private void showSingleAnnotation(long ownerID) {
        this.listAnnotations.removeAll();
        List l = this.areas.get(new Long(ownerID));
        for (MultilineLabel c : l) {
            if (c != this.annotationArea) {
                c.setBackground(c.getOriginalBackground());
                this.listAnnotations.add(c);
                continue;
            }
            c.setBackground(c.getOriginalBackground());
            JScrollPane pane = new JScrollPane(c);
            pane.getVerticalScrollBar().setVisible(true);
            this.listAnnotations.add(pane);
        }
        this.setComponentsEnabled(false);
    }

    private void showDateAnnotation(long ownerID, int index) {
        MultilineLabel c;
        List l = this.areas.get(new Long(ownerID));
        int j = index;
        long userID = this.model.getUserDetails().getId();
        if (ownerID == userID) {
            ++j;
        }
        for (int i = 0; i < l.size(); ++i) {
            c = (MultilineLabel)l.get(i);
            c.setBackground(c.getOriginalBackground());
            if (j != i) continue;
            this.clearButton.setEnabled(c == this.annotationArea);
            c.setBackground(UIUtilities.HIGHLIGHT);
        }
        c = (MultilineLabel)l.get(j);
        this.scrollToNode(c);
        if (ownerID == userID) {
            if (index == -1) {
                this.clearButton.setEnabled(true);
                this.saveButton.setEnabled(true);
                this.deleteButton.setEnabled(false);
            } else {
                this.clearButton.setEnabled(false);
                this.saveButton.setEnabled(false);
                this.deleteButton.setEnabled(true);
            }
        } else {
            this.setComponentsEnabled(false);
        }
    }

    private void buildTreeNode(OwnerNode parent, List annotations, DefaultTreeModel dtm) {
        ArrayList<MultilineLabel> l;
        long ownerID = parent.getOwnerID();
        Long id = new Long(ownerID);
        boolean user = this.model.getUserDetails().getId() == ownerID;
        TimeNode node = new TimeNode(ownerID, -1, null);
        if (user) {
            dtm.insertNodeInto(node, parent, parent.getChildCount());
            AnnotatorUtil.setAnnotationAreaDefault(this.annotationArea, node.toString());
        }
        if ((annotations == null || annotations.size() == 0) && user) {
            ArrayList<MultilineLabel> l2 = new ArrayList<MultilineLabel>(1);
            l2.add(this.annotationArea);
            this.areas.put(id, l2);
            return;
        }
        int row = 0;
        if (user) {
            l = new ArrayList(annotations.size() + 1);
            l.add(this.annotationArea);
            row = 1;
        } else {
            l = new ArrayList<MultilineLabel>(annotations.size());
        }
        Iterator i = annotations.iterator();
        int index = 0;
        while (i.hasNext()) {
            AnnotationData data = (AnnotationData)i.next();
            Timestamp date = data.getLastModified();
            if (date == null) {
                date = new Timestamp(new Date().getTime());
            }
            node = new TimeNode(ownerID, index, date);
            data = (AnnotationData)annotations.get(index);
            dtm.insertNodeInto(node, parent, parent.getChildCount());
            MultilineLabel area = new MultilineLabel();
            area.setEditable(false);
            area.setOpaque(true);
            area.setBorder(new TitledLineBorder(node.toString()));
            area.setText(data.getText());
            if (index % 2 == row) {
                area.setOriginalBackground(UIUtilities.BACKGROUND);
            } else {
                area.setOriginalBackground(UIUtilities.BACKGROUND_ONE);
            }
            l.add(area);
            ++index;
        }
        this.areas.put(id, l);
    }

    AnnotatorEditorView(int layout) {
        this.layout = layout;
        this.areas = new HashMap<Long, List>();
        this.selectedOwnerID = -1L;
    }

    void initialize(AnnotatorEditorModel model, AnnotatorEditorControl controller) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        this.controller = controller;
        this.model = model;
        this.initComponents();
        this.buildGUI();
    }

    void setComponentsEnabled(boolean b) {
        this.saveButton.setEnabled(b);
        this.clearButton.setEnabled(b);
        this.deleteButton.setEnabled(b);
    }

    void showAnnotations() {
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)dtm.getRoot();
        root.removeAllChildren();
        dtm.reload(root);
        this.listAnnotations.removeAll();
        this.areas.clear();
        this.deleteButton.setSelected(false);
        ExperimenterData userDetails = this.model.getUserDetails();
        if (userDetails == null) {
            return;
        }
        Map annotations = this.model.getAnnotations();
        Iterator i = annotations.keySet().iterator();
        int index = 0;
        DefaultMutableTreeNode currentUser = null;
        int number = 0;
        while (i.hasNext()) {
            Long id = (Long)i.next();
            List list = (List)annotations.get(id);
            number += list.size();
            ExperimenterData data = ((AnnotationData)list.get(0)).getOwner();
            OwnerNode owner = new OwnerNode(data);
            owner.setNumberOfAnnotations(list.size());
            dtm.insertNodeInto(owner, root, root.getChildCount());
            this.buildTreeNode(owner, list, dtm);
            if (userDetails.getId() == (long)id.intValue()) {
                currentUser = owner;
            }
            ++index;
        }
        if (currentUser == null) {
            currentUser = new OwnerNode(userDetails);
            dtm.insertNodeInto(currentUser, root, root.getChildCount());
            this.buildTreeNode((OwnerNode)currentUser, null, dtm);
        }
        TreePath path = new TreePath(currentUser.getPath());
        this.treeDisplay.setSelectionPath(path);
        this.treeDisplay.expandPath(path);
        String text = "Total: " + number + " annotation";
        if (number > 1) {
            text = text + "s";
        }
        this.commentLabel.setText(text);
    }

    void onSelectedDisplay() {
        this.setComponentsEnabled(false);
        DefaultTreeModel dtm = (DefaultTreeModel)this.treeDisplay.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)dtm.getRoot();
        root.removeAllChildren();
        dtm.reload(root);
        this.listAnnotations.removeAll();
        this.areas.clear();
        this.annotationArea.getDocument().removeDocumentListener(this.listener);
        this.annotationArea.setText("");
        this.annotationArea.getDocument().addDocumentListener(this.listener);
        this.model.setAnnotated(false);
        this.commentLabel.setText("");
        this.repaint();
    }

    boolean isAnnotatable() {
        Object o = this.treeDisplay.getLastSelectedPathComponent();
        if (o instanceof OwnerNode) {
            ExperimenterData details = this.model.getUserDetails();
            return details.getId() == ((OwnerNode)o).getOwnerID();
        }
        if (o instanceof TimeNode) {
            TimeNode tm = (TimeNode)o;
            int index = tm.getIndex();
            Map annotations = this.model.getAnnotations();
            List list = (List)annotations.get(tm.getOwnerID());
            if (list == null || list.size() == 0) {
                return true;
            }
            return index == list.size() - 1;
        }
        return false;
    }

    String getAnnotationText() {
        String s = this.annotationArea.getText();
        if (s == null) {
            return "";
        }
        return s.trim();
    }

    boolean hasAnnotation() {
        AnnotationData data = this.model.getAnnotationData(0);
        return data != null;
    }

    boolean hasDataToSave() {
        boolean b = true;
        if (this.getAnnotationText().length() == 0) {
            b = false;
        }
        return this.isAnnotatable() && b;
    }

    boolean hasTextEntered() {
        return this.getAnnotationText().length() != 0;
    }

    List getSelectedAnnotations() {
        TreePath[] paths = this.treeDisplay.getSelectionPaths();
        if (paths == null) {
            return null;
        }
        int n = paths.length;
        if (n == 0) {
            return null;
        }
        ArrayList<AnnotationData> toRemove = new ArrayList<AnnotationData>();
        long userID = this.model.getUserDetails().getId();
        for (int i = 0; i < paths.length; ++i) {
            AnnotationData data;
            TimeNode node;
            Object pathComponent = paths[i].getLastPathComponent();
            if (!(pathComponent instanceof TimeNode) || (node = (TimeNode)pathComponent).getUserObject() == null || node.getOwnerID() != userID || (data = this.model.getAnnotationData(node.getIndex())) == null) continue;
            toRemove.add(data);
        }
        return toRemove;
    }
}

