/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.annotator.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.agents.util.annotator.AnnotationsEditorLoader;
import org.openmicroscopy.shoola.agents.util.annotator.AnnotationsEditorSaver;
import org.openmicroscopy.shoola.agents.util.annotator.AnnotatorEditorLoader;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorEditor;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorFactory;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorUtil;
import pojos.AnnotationData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.ImageData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AnnotatorEditorModel {
    private int state;
    private Map annotations;
    private DataObject dataObject;
    private boolean annotated;
    private Set<DataObject> siblings;
    private AnnotatorEditorLoader currentLoader;
    protected AnnotatorEditor component;

    AnnotatorEditorModel(DataObject dataObject) {
        this.dataObject = dataObject;
        this.state = 1;
    }

    void initialize(AnnotatorEditor component) {
        this.component = component;
    }

    int getState() {
        return this.state;
    }

    void discard() {
        this.cancel();
        this.state = 2;
    }

    void cancel() {
        if (this.currentLoader != null) {
            this.currentLoader.cancel();
            this.currentLoader = null;
        }
        this.state = 3;
    }

    Map getAnnotations() {
        return this.annotations;
    }

    List getAnnotations(long ownerID) {
        if (this.annotations == null) {
            return null;
        }
        return (List)this.annotations.get(new Long(ownerID));
    }

    void setAnnotations(Map map) {
        HashMap<Long, ArrayList<AnnotationData>> sortedAnnotations = new HashMap<Long, ArrayList<AnnotationData>>();
        for (Long index : map.keySet()) {
            Set set = (Set)map.get(index);
            for (AnnotationData annotation : set) {
                Long ownerID = new Long(annotation.getOwner().getId());
                ArrayList<AnnotationData> userAnnos = (ArrayList<AnnotationData>)sortedAnnotations.get(ownerID);
                if (userAnnos == null) {
                    userAnnos = new ArrayList<AnnotationData>();
                    sortedAnnotations.put(ownerID, userAnnos);
                }
                userAnnos.add(annotation);
            }
        }
        for (Long ownerID : sortedAnnotations.keySet()) {
            List annotations = (List)sortedAnnotations.get(ownerID);
            AnnotatorUtil.sortAnnotationByDate(annotations);
        }
        this.annotations = sortedAnnotations;
        this.state = 3;
    }

    void fireAnnotationsRetrieval(DataObject object) {
        this.currentLoader = new AnnotationsEditorLoader(this.component, object);
        this.currentLoader.load();
        this.state = 4;
    }

    void fireAnnotationsRetrieval() {
        this.fireAnnotationsRetrieval(this.dataObject);
    }

    void fireAnnotationCreate(AnnotationData data, int index) {
        this.state = 5;
        switch (index) {
            default: {
                this.currentLoader = new AnnotationsEditorSaver(this.component, this.dataObject, data, 0);
                break;
            }
            case 100: {
                this.currentLoader = this.siblings != null ? new AnnotationsEditorSaver(this.component, this.siblings, this.dataObject.getClass(), data, 0) : new AnnotationsEditorSaver(this.component, this.dataObject, data, 0);
            }
        }
        this.currentLoader.load();
    }

    void fireAnnotationDelete(List data) {
        this.state = 5;
        this.currentLoader = new AnnotationsEditorSaver(this.component, this.dataObject, data);
        this.currentLoader.load();
    }

    void fireAnnotationUpdate(AnnotationData data) {
        this.state = 5;
        this.currentLoader = new AnnotationsEditorSaver(this.component, this.dataObject, data, 1);
        this.currentLoader.load();
    }

    AnnotationData getAnnotationData(int index) {
        long id = this.getUserDetails().getId();
        if (this.dataObject == null) {
            return null;
        }
        if (this.dataObject instanceof ImageData || this.dataObject instanceof DatasetData) {
            List l = this.getAnnotations(id);
            if (l == null || l.size() == 0) {
                return null;
            }
            return (AnnotationData)l.get(index);
        }
        return null;
    }

    AnnotationData getLastAnnotationFor(long ownerID) {
        List l = this.getAnnotations(ownerID);
        if (l == null || l.size() == 0) {
            return null;
        }
        return (AnnotationData)l.get(0);
    }

    ExperimenterData getUserDetails() {
        return (ExperimenterData)AnnotatorFactory.getRegistry().lookup("/current_user/details");
    }

    void setAnnotated(boolean b) {
        this.annotated = b;
    }

    boolean isAnnotated() {
        return this.annotated;
    }

    DataObject getDataObject() {
        return this.dataObject;
    }

    String getDataObjectName() {
        if (this.dataObject instanceof ImageData) {
            return AnnotatorUtil.getPartialName(((ImageData)this.dataObject).getName());
        }
        if (this.dataObject instanceof ImageData) {
            return ((DatasetData)this.dataObject).getName();
        }
        return "";
    }

    void setState(int state) {
        this.state = state;
    }

    void setDataObject(DataObject object) {
        this.dataObject = object;
    }

    void setSiblings(Set<DataObject> objects) {
        this.siblings = objects;
    }

    Set getSiblings() {
        return this.siblings;
    }
}

