/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.annotator.view;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.agents.util.annotator.actions.AnnotatorEditorAction;
import org.openmicroscopy.shoola.agents.util.annotator.actions.DeleteAction;
import org.openmicroscopy.shoola.agents.util.annotator.actions.SaveAction;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorEditor;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorEditorView;

class AnnotatorEditorControl
implements ChangeListener,
PropertyChangeListener {
    static final Integer DELETE = new Integer(0);
    static final Integer SAVE = new Integer(1);
    private Map<Integer, AnnotatorEditorAction> actionsMap;
    private AnnotatorEditor model;
    private AnnotatorEditorView view;

    private void createActions() {
        this.actionsMap.put(DELETE, new DeleteAction(this.model));
        this.actionsMap.put(SAVE, new SaveAction(this.model));
    }

    private void attachListeners() {
        this.model.addChangeListener(this);
    }

    AnnotatorEditorControl(AnnotatorEditor model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.actionsMap = new HashMap<Integer, AnnotatorEditorAction>();
    }

    void initialize(AnnotatorEditorView view) {
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.view = view;
        this.createActions();
        this.attachListeners();
    }

    AnnotatorEditorAction getAction(Integer id) {
        return this.actionsMap.get(id);
    }

    public void stateChanged(ChangeEvent e) {
        switch (this.model.getState()) {
            case 2: 
            case 4: 
            case 5: {
                break;
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("annotateOne".equals(name)) {
            this.model.save(101);
        } else if ("annotateAll".equals(name)) {
            this.model.save(100);
        }
    }
}

