/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.annotator.view;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Window;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorEditor;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorEditorControl;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorEditorModel;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorEditorView;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorFactory;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorSavingDialog;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;
import pojos.AnnotationData;
import pojos.DataObject;
import pojos.ImageData;

class AnnotatorEditorComponent
extends AbstractComponent
implements AnnotatorEditor {
    private AnnotatorEditorModel model;
    private AnnotatorEditorControl controller;
    private AnnotatorEditorView view;

    private Container getOwner() {
        Container source = this.view;
        Container parent = null;
        while (source != null) {
            parent = source.getParent();
            if (parent instanceof JFrame) {
                return parent;
            }
            if (parent instanceof JDialog) {
                return parent;
            }
            source = parent;
        }
        return null;
    }

    AnnotatorEditorComponent(AnnotatorEditorModel model, int layout) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = new AnnotatorEditorControl(this);
        this.view = new AnnotatorEditorView(layout);
    }

    void initialize() {
        this.controller.initialize(this.view);
        this.view.initialize(this.model, this.controller);
    }

    public void activate() {
        switch (this.model.getState()) {
            case 1: 
            case 3: {
                this.view.onSelectedDisplay();
                this.model.fireAnnotationsRetrieval();
                this.fireStateChange();
                break;
            }
            case 2: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED state.");
            }
        }
    }

    public void discard() {
        if (this.model.getState() != 2) {
            this.model.discard();
            this.fireStateChange();
        }
    }

    public void close() {
    }

    public int getState() {
        return this.model.getState();
    }

    public void cancel() {
        this.discard();
    }

    public void setAnnotations(Map annotations) {
        if (this.model.getState() != 4) {
            this.firePropertyChange("annotationLoaded", Boolean.FALSE, Boolean.TRUE);
            return;
        }
        this.model.setAnnotations(annotations);
        this.view.showAnnotations();
        this.firePropertyChange("annotationLoaded", Boolean.FALSE, Boolean.TRUE);
        this.fireStateChange();
    }

    public void setAnnotationSaved(List result) {
        if (this.model.getState() != 5) {
            throw new IllegalStateException("This method can only be invoked in the SAVING state.");
        }
        this.view.setCursor(Cursor.getPredefinedCursor(0));
        this.model.setState(3);
        this.fireStateChange();
        Iterator i = result.iterator();
        long id = this.model.getDataObject().getId();
        while (i.hasNext()) {
            DataObject object = (DataObject)i.next();
            if (object.getId() != id) continue;
            this.firePropertyChange("annotated", null, object);
            break;
        }
    }

    public void delete() {
        if (this.model.getState() != 3) {
            throw new IllegalStateException("This method can only be invoked in the READY state.");
        }
        List l = this.view.getSelectedAnnotations();
        if (l == null || l.size() == 0) {
            UserNotifier un = AnnotatorFactory.getRegistry().getUserNotifier();
            un.notifyInfo("Annotation", "No annotation to delete");
            return;
        }
        this.model.fireAnnotationDelete(l);
        this.fireStateChange();
    }

    public JComponent getUI() {
        return this.view;
    }

    public boolean hasAnnotation() {
        if (this.model.getState() != 3) {
            return false;
        }
        return this.view.hasAnnotation();
    }

    public boolean hasDataToSave() {
        if (this.model.getState() != 3) {
            return false;
        }
        return this.view.hasDataToSave();
    }

    public boolean hasTextEntered() {
        if (this.model.getState() != 3) {
            return false;
        }
        return this.view.hasTextEntered();
    }

    public void retrieveAnnotations(DataObject object) {
        switch (this.model.getState()) {
            case 1: 
            case 3: {
                break;
            }
            default: {
                this.model.cancel();
            }
        }
        this.model.setDataObject(object);
        this.view.onSelectedDisplay();
        if (object != null) {
            this.model.fireAnnotationsRetrieval(object);
        }
    }

    public void save() {
        if (this.model.getState() != 3) {
            return;
        }
        Set siblings = this.model.getSiblings();
        if (siblings == null || siblings.size() == 1) {
            this.save(101);
            return;
        }
        Window dialog = null;
        Container c = this.getOwner();
        if (c instanceof JFrame) {
            dialog = new AnnotatorSavingDialog((JFrame)c, 1, this.model.getDataObjectName());
        } else if (c instanceof JDialog) {
            dialog = new AnnotatorSavingDialog((JDialog)c, 1, this.model.getDataObjectName());
        }
        if (dialog != null) {
            dialog.addPropertyChangeListener(this.controller);
            UIUtilities.centerAndShow(dialog);
        }
    }

    public void save(int index) {
        if (this.model.getState() != 3) {
            throw new IllegalStateException("This method can only be invoked in the READY state.");
        }
        AnnotationData data = null;
        if (!this.model.isAnnotated()) {
            return;
        }
        if (data == null) {
            DataObject ho = this.model.getDataObject();
            data = ho instanceof ImageData ? new AnnotationData(0) : new AnnotationData(1);
            data.setText(this.view.getAnnotationText());
            this.model.fireAnnotationCreate(data, index);
        } else {
            data.setText(this.view.getAnnotationText());
            this.model.fireAnnotationUpdate(data);
        }
        this.fireStateChange();
    }

    public void addSelectedNodes(List nodes) {
        if (nodes == null || nodes.size() == 0) {
            return;
        }
        HashSet<DataObject> objects = new HashSet<DataObject>();
        DataObject object = this.model.getDataObject();
        Iterator i = nodes.iterator();
        Class<?> klass = object.getClass();
        while (i.hasNext()) {
            DataObject n = (DataObject)i.next();
            if (!klass.equals(n.getClass())) continue;
            objects.add(n);
        }
        this.model.setSiblings(objects);
    }
}

