/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.annotator.view;

import java.awt.Cursor;
import java.util.List;
import java.util.Map;
import org.openmicroscopy.shoola.agents.util.annotator.view.Annotator;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorControl;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorModel;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorSavingDialog;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorView;
import org.openmicroscopy.shoola.util.ui.MessageBox;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;
import pojos.AnnotationData;

class AnnotatorComponent
extends AbstractComponent
implements Annotator {
    private AnnotatorModel model;
    private AnnotatorControl controller;
    private AnnotatorView view;

    AnnotatorComponent(AnnotatorModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = new AnnotatorControl(this);
        this.view = new AnnotatorView();
    }

    void initialize() {
        this.controller.initialize(this.view);
        this.view.initialize(this.model, this.controller);
    }

    public void activate() {
        switch (this.model.getState()) {
            case 1: {
                this.model.fireAnnotationsRetrieval();
                this.fireStateChange();
                break;
            }
            case 2: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED state.");
            }
        }
    }

    public void discard() {
        if (this.model.getState() != 2) {
            this.model.discard();
            this.fireStateChange();
        }
    }

    public void close() {
        MessageBox msg;
        if (this.view.hasDataToSave() && (msg = new MessageBox(this.view, "Save Annotation", "Do you want to save the annotation before closing?")).centerMsgBox() == 1) {
            this.finish();
        }
        this.model.discard();
        this.fireStateChange();
    }

    public int getState() {
        return this.model.getState();
    }

    public void finish() {
        if (this.model.getState() != 3) {
            throw new IllegalStateException("This method can only be invoked in the READY state.");
        }
        AnnotatorSavingDialog dialog = new AnnotatorSavingDialog(this.view, 0, this.view.getSelectedObjectName());
        dialog.addPropertyChangeListener(this.controller);
        UIUtilities.centerAndShow(dialog);
    }

    public void save(int index) {
        if (this.model.getState() != 3) {
            throw new IllegalStateException("This method can only be invoked in the READY state.");
        }
        AnnotationData d = this.model.getAnnotationType();
        d.setText(this.view.getAnnotationText());
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        this.controller.getAction(AnnotatorControl.FINISH).setEnabled(false);
        switch (index) {
            case 101: {
                this.model.fireAnnotationSaving(d, this.view.getSelectedDataObject());
                break;
            }
            default: {
                this.model.fireAnnotationSaving(d, null);
            }
        }
        this.fireStateChange();
    }

    public void cancel() {
        if (this.model.getState() == 2) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        this.model.discard();
        this.fireStateChange();
    }

    public void setAnnotations(Map annotations) {
        if (this.model.getState() != 4) {
            throw new IllegalStateException("This method can only be invoked in the LOADING state.");
        }
        this.model.setAnnotations(annotations);
        this.view.showAnnotations();
        this.fireStateChange();
    }

    public void saveAnnotations(List results) {
        if (this.model.getState() != 5) {
            throw new IllegalStateException("This method can only be invoked in the SAVING state.");
        }
        this.view.setCursor(Cursor.getPredefinedCursor(0));
        this.firePropertyChange("annotated", null, results);
    }
}

