/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.annotator;

import org.openmicroscopy.shoola.agents.util.annotator.view.Annotator;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorFactory;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.events.DSCallAdapter;
import org.openmicroscopy.shoola.env.data.views.DataHandlerView;
import pojos.DatasetData;
import pojos.ImageData;

public abstract class AnnotatorLoader
extends DSCallAdapter {
    protected final Annotator viewer;
    protected final Registry registry;
    protected final DataHandlerView aView;

    protected boolean checkAnnotationType(Class c) {
        if (DatasetData.class.equals((Object)c)) {
            return true;
        }
        return ImageData.class.equals((Object)c);
    }

    protected AnnotatorLoader(Annotator viewer) {
        if (viewer == null) {
            throw new NullPointerException("No viewer.");
        }
        this.viewer = viewer;
        this.registry = AnnotatorFactory.getRegistry();
        this.aView = (DataHandlerView)this.registry.getDataServicesView(DataHandlerView.class);
    }

    public void onEnd() {
    }

    public void handleNullResult() {
        this.handleException(new Exception("No data available."));
    }

    public void handleCancellation() {
        String info = "The data retrieval has been cancelled.";
        this.registry.getLogger().info((Object)this, info);
        this.registry.getUserNotifier().notifyInfo("Data Retrieval Cancellation", info);
    }

    public void handleException(Throwable exc) {
        String s = "Data Retrieval Failure: ";
        this.registry.getLogger().error((Object)this, s + exc);
        this.registry.getUserNotifier().notifyError("Data Retrieval Failure", s, exc);
        this.viewer.cancel();
    }

    public abstract void load();

    public abstract void cancel();
}

