/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.annotator;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.agents.util.annotator.AnnotatorLoader;
import org.openmicroscopy.shoola.agents.util.annotator.view.Annotator;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import pojos.AnnotationData;

public class AnnotationsSaver
extends AnnotatorLoader {
    private static final int CREATE = 0;
    private static final int UPDATE = 1;
    private static final int UPDATE_AND_CREATE = 2;
    private int mode;
    private Map toUpdate;
    private Set toAnnotate;
    private AnnotationData annotation;
    private int index;
    private CallHandle handle;

    private void checkMode(int m) {
        switch (m) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Annotate mode not supported.");
            }
        }
    }

    public AnnotationsSaver(Annotator viewer, Map toUpdate, int mode) {
        super(viewer);
        if (toUpdate == null && toUpdate.size() == 0) {
            throw new IllegalArgumentException("No data to save.");
        }
        this.checkMode(mode);
        this.mode = mode;
        this.index = 1;
        this.toUpdate = toUpdate;
    }

    public AnnotationsSaver(Annotator viewer, Map toUpdate, Set toAnnotate, AnnotationData annotation, int mode) {
        super(viewer);
        if (toUpdate == null && toUpdate.size() == 0) {
            throw new IllegalArgumentException("No data to save.");
        }
        if (annotation == null) {
            throw new IllegalArgumentException("No annotation.");
        }
        if (toAnnotate == null && toAnnotate.size() == 0) {
            throw new IllegalArgumentException("No data to save.");
        }
        this.checkMode(mode);
        this.mode = mode;
        this.index = 2;
        this.toUpdate = toUpdate;
        this.annotation = annotation;
        this.toAnnotate = toAnnotate;
    }

    public AnnotationsSaver(Annotator viewer, Set toAnnotate, AnnotationData annotation, int mode) {
        super(viewer);
        if (annotation == null) {
            throw new IllegalArgumentException("No annotation.");
        }
        if (toAnnotate == null && toAnnotate.size() == 0) {
            throw new IllegalArgumentException("No data to save.");
        }
        this.checkMode(mode);
        this.mode = mode;
        this.index = 0;
        this.annotation = annotation;
        this.toAnnotate = toAnnotate;
    }

    public void load() {
        if (this.mode == 0) {
            switch (this.index) {
                case 0: {
                    this.handle = this.aView.createAnnotation(this.toAnnotate, this.annotation, (AgentEventListener)this);
                    break;
                }
                case 1: {
                    this.handle = this.aView.updateAnnotation(this.toUpdate, this);
                    break;
                }
                case 2: {
                    this.handle = this.aView.updateAndCreateAnnotation(this.toUpdate, this.toAnnotate, this.annotation, this);
                }
            }
        } else {
            this.handle = this.aView.annotateChildren(this.toAnnotate, this.annotation, this);
        }
    }

    public void cancel() {
        this.handle.cancel();
    }

    public void handleResult(Object result) {
        if (this.viewer.getState() == 2) {
            return;
        }
        this.viewer.saveAnnotations((List)result);
    }
}

