/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.openmicroscopy.shoola.agents.hiviewer.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.hiviewer.treeview.TreeViewNode;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import pojos.CategoryData;
import pojos.CategoryGroupData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.GroupData;
import pojos.ImageData;
import pojos.ProjectData;

public class ViewerSorter {
    private boolean ascending;
    private boolean byDate;
    private Collection collection;
    private List results;

    private int compareDates(Date d1, Date d2) {
        long n1 = d1.getTime();
        long n2 = d2.getTime();
        int v = 0;
        if (n1 < n2) {
            v = -1;
        } else if (n1 > n2) {
            v = 1;
        }
        return v;
    }

    private int compareStrings(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        int v = 0;
        int result = s1.toLowerCase().compareTo(s2.toLowerCase());
        if (result < 0) {
            v = -1;
        } else if (result > 0) {
            v = 1;
        }
        return v;
    }

    private int compareObjects(Object o1, Object o2) {
        return this.compareStrings(o1.toString(), o2.toString());
    }

    private int compareBooleans(Boolean bool1, Boolean bool2) {
        boolean b1 = bool1;
        boolean b2 = bool2;
        int v = 0;
        v = b1 == b2 ? 0 : (b1 ? -1 : 1);
        return v;
    }

    private int compareNumbers(Number n1, Number n2) {
        double d1 = n1.doubleValue();
        double d2 = n2.doubleValue();
        int v = 0;
        if (d1 < d2) {
            v = -1;
        } else if (d1 > d2) {
            v = 1;
        }
        return v;
    }

    private int compareLongs(long d1, long d2) {
        int v = 0;
        if (d1 < d2) {
            v = -1;
        } else if (d1 > d2) {
            v = 1;
        }
        return v;
    }

    private int compareTimestamps(Timestamp t1, Timestamp t2) {
        int v = 0;
        int r = t1.compareTo(t2);
        if (r < 0) {
            v = -1;
        } else if (r > 0) {
            v = 1;
        }
        return v;
    }

    private int compareDataObjects(DataObject o1, DataObject o2) {
        if (!this.byDate) {
            int r = this.compareStrings(this.getNameFor(o1), this.getNameFor(o2));
            if (r == 0) {
                return this.compareLongs(o1.getId(), o2.getId());
            }
            return r;
        }
        return this.compareTimestamps(this.getTimeFor(o1), this.getTimeFor(o2));
    }

    private int compareTreeImageDisplays(TreeImageDisplay o1, TreeImageDisplay o2) {
        Object ob1 = o1.getUserObject();
        Object ob2 = o2.getUserObject();
        if (!(ob1 instanceof DataObject)) {
            return -1;
        }
        if (!(ob2 instanceof DataObject)) {
            return 1;
        }
        return this.compareDataObjects((DataObject)ob1, (DataObject)ob2);
    }

    private int compareImageDisplays(ImageDisplay o1, ImageDisplay o2) {
        Object ob1 = o1.getHierarchyObject();
        Object ob2 = o2.getHierarchyObject();
        if (!(ob1 instanceof DataObject)) {
            return -1;
        }
        if (!(ob2 instanceof DataObject)) {
            return 1;
        }
        return this.compareDataObjects((DataObject)ob1, (DataObject)ob2);
    }

    private int compareTreeViewNodes(TreeViewNode o1, TreeViewNode o2) {
        Object ob1 = o1.getUserObject();
        Object ob2 = o2.getUserObject();
        if (!(ob1 instanceof DataObject)) {
            return -1;
        }
        if (!(ob2 instanceof DataObject)) {
            return 1;
        }
        return this.compareImageDisplays((ImageDisplay)ob1, (ImageDisplay)ob2);
    }

    private Timestamp getTimeFor(DataObject o) {
        Timestamp t = null;
        if (o instanceof ImageData) {
            try {
                t = ((ImageData)o).getInserted();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (t == null) {
            t = new Timestamp(new Date().getTime());
        }
        return t;
    }

    public String getNameFor(Object obj) {
        if (obj instanceof ProjectData) {
            return ((ProjectData)obj).getName();
        }
        if (obj instanceof DatasetData) {
            return ((DatasetData)obj).getName();
        }
        if (obj instanceof ImageData) {
            return ((ImageData)obj).getName();
        }
        if (obj instanceof CategoryGroupData) {
            return ((CategoryGroupData)obj).getName();
        }
        if (obj instanceof CategoryData) {
            return ((CategoryData)obj).getName();
        }
        if (obj instanceof ExperimenterData) {
            ExperimenterData exp = (ExperimenterData)obj;
            return exp.getLastName() + " " + exp.getFirstName();
        }
        if (obj instanceof GroupData) {
            return ((GroupData)obj).getName();
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return "";
    }

    private int compare(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        int result = 0;
        result = o1 instanceof Number || o1 instanceof Integer || o1 instanceof Double || o1 instanceof Float ? this.compareNumbers((Number)o1, (Number)o2) : (o1 instanceof Date ? this.compareDates((Date)o1, (Date)o2) : (o1 instanceof String ? this.compareStrings((String)o1, (String)o2) : (o1 instanceof Boolean ? this.compareBooleans((Boolean)o1, (Boolean)o2) : (o1 instanceof DataObject ? this.compareDataObjects((DataObject)o1, (DataObject)o2) : (o1 instanceof TreeImageDisplay ? this.compareTreeImageDisplays((TreeImageDisplay)o1, (TreeImageDisplay)o2) : (o1 instanceof ImageDisplay ? this.compareImageDisplays((ImageDisplay)o1, (ImageDisplay)o2) : (o1 instanceof TreeViewNode ? this.compareTreeViewNodes((TreeViewNode)o1, (TreeViewNode)o2) : (o1 instanceof Timestamp ? this.compareTimestamps((Timestamp)o1, (Timestamp)o2) : this.compareObjects(o1, o2)))))))));
        if (result != 0) {
            return this.ascending ? result : -result;
        }
        return result;
    }

    private void shuttlesort(Object[] from, Object[] to, int low, int high) {
        if (high - low < 2) {
            return;
        }
        int middle = (low + high) / 2;
        this.shuttlesort(to, from, low, middle);
        this.shuttlesort(to, from, middle, high);
        int p = low;
        int q = middle;
        if (high - low >= 4 && this.compare(from[middle - 1], from[middle]) <= 0) {
            for (int i = low; i < high; ++i) {
                to[i] = from[i];
            }
            return;
        }
        for (int i = low; i < high; ++i) {
            to[i] = q >= high || p < middle && this.compare(from[p], from[q]) <= 0 ? from[p++] : from[q++];
        }
    }

    private void initialize() {
        this.ascending = true;
        this.byDate = false;
    }

    public ViewerSorter() {
        this.initialize();
    }

    public ViewerSorter(Collection collection) {
        if (collection == null) {
            throw new NullPointerException("No collection");
        }
        this.collection = collection;
        this.initialize();
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean b) {
        if (b == this.ascending) {
            return;
        }
        this.ascending = b;
    }

    public boolean isByDate() {
        return this.byDate;
    }

    public void setByDate(boolean b) {
        this.byDate = b;
    }

    public List sort(Collection collection) {
        if (collection == null) {
            throw new NullPointerException("No collection to sort.");
        }
        this.collection = collection;
        return this.sort();
    }

    public List sort() {
        if (this.collection == null) {
            throw new NullPointerException("No collection to sort.");
        }
        Iterator i = this.collection.iterator();
        Object[] array = new Object[this.collection.size()];
        Object[] clone = new Object[this.collection.size()];
        int index = 0;
        while (i.hasNext()) {
            Object obj = i.next();
            array[index] = obj;
            clone[index] = obj;
            ++index;
        }
        this.shuttlesort(clone, array, 0, array.length);
        this.results = new ArrayList();
        for (int j = 0; j < array.length; ++j) {
            this.results.add(array[j]);
        }
        return this.results;
    }

    public Object[] sortArray(Collection collection) {
        if (collection == null) {
            throw new NullPointerException("No collection to sort.");
        }
        this.collection = collection;
        return this.sortArray();
    }

    public Object[] sortArray() {
        if (this.collection == null) {
            throw new NullPointerException("No collection to sort.");
        }
        Iterator i = this.collection.iterator();
        Object[] array = new Object[this.collection.size()];
        Object[] clone = new Object[this.collection.size()];
        int index = 0;
        while (i.hasNext()) {
            Object obj = i.next();
            array[index] = obj;
            clone[index] = obj;
            ++index;
        }
        this.shuttlesort(clone, array, 0, array.length);
        return array;
    }
}

