/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util;

import java.util.HashSet;
import java.util.Set;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.util.ui.clsf.TreeCheckNode;
import pojos.CategoryData;
import pojos.CategoryGroupData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.PermissionData;

public class DataHandlerTranslator {
    private static TreeCheckNode transformDatasetCheckNode(DatasetData data) {
        if (data == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        IconManager im = IconManager.getInstance();
        TreeCheckNode node = new TreeCheckNode(data, im.getIcon(IconManager.DATASET), data.getName(), true);
        return node;
    }

    private static TreeCheckNode transformCategoryCheckNode(CategoryData data) {
        if (data == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        IconManager im = IconManager.getInstance();
        TreeCheckNode category = new TreeCheckNode(data, im.getIcon(IconManager.CATEGORY), data.getName(), true);
        return category;
    }

    private static TreeCheckNode transformCategoryGroupCheckNode(CategoryGroupData data, long userID, long groupID) {
        if (data == null) {
            throw new IllegalArgumentException("Cannot be null");
        }
        IconManager im = IconManager.getInstance();
        TreeCheckNode group = new TreeCheckNode(data, im.getIcon(IconManager.CATEGORY_GROUP), data.getName(), false);
        Set categories = data.getCategories();
        for (CategoryData child : categories) {
            if (!DataHandlerTranslator.isWritable((DataObject)child, userID, groupID)) continue;
            group.addChildDisplay(DataHandlerTranslator.transformCategoryCheckNode(child));
        }
        return group;
    }

    public static Set transformDataObjectsCheckNode(Set dataObjects, long userID, long groupID) {
        if (dataObjects == null) {
            throw new IllegalArgumentException("No objects.");
        }
        HashSet<TreeCheckNode> results = new HashSet<TreeCheckNode>(dataObjects.size());
        for (DataObject ho : dataObjects) {
            if (!DataHandlerTranslator.isWritable(ho, userID, groupID)) continue;
            if (ho instanceof CategoryGroupData) {
                Set categories = ((CategoryGroupData)ho).getCategories();
                if (categories == null || categories.size() == 0) continue;
                results.add(DataHandlerTranslator.transformCategoryGroupCheckNode((CategoryGroupData)ho, userID, groupID));
                continue;
            }
            if (ho instanceof CategoryData) {
                results.add(DataHandlerTranslator.transformCategoryCheckNode((CategoryData)ho));
                continue;
            }
            if (!(ho instanceof DatasetData)) continue;
            results.add(DataHandlerTranslator.transformDatasetCheckNode((DatasetData)ho));
        }
        return results;
    }

    public static boolean isWritable(DataObject ho, long userID, long groupID) {
        PermissionData permissions = ho.getPermissions();
        if (userID == ho.getOwner().getId()) {
            return permissions.isUserWrite();
        }
        return permissions.isGroupWrite();
    }
}

