/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.view.PopupMenu;
import org.openmicroscopy.shoola.agents.treeviewer.view.StatusBar;
import org.openmicroscopy.shoola.agents.treeviewer.view.ToolBar;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerControl;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerModel;
import org.openmicroscopy.shoola.agents.util.DataHandler;
import org.openmicroscopy.shoola.env.ui.TaskBar;
import org.openmicroscopy.shoola.env.ui.TopWindow;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class TreeViewerWin
extends TopWindow {
    private static final String TITLE = "Data Manager";
    private static final int DIVIDER_LOCATION = 300;
    private TreeViewerControl controller;
    private TreeViewerModel model;
    private JSplitPane splitPane;
    private JScrollPane workingPane;
    private JTabbedPane tabs;
    private List<JMenuItem> menuItems = new ArrayList<JMenuItem>();
    private ToolBar toolBar;
    private StatusBar statusBar;
    private Rectangle invokerBounds;

    private boolean isBrowserVisible(Browser browser) {
        Component[] comps = this.tabs.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!comps[i].equals(browser.getUI())) continue;
            return true;
        }
        return false;
    }

    private void createTabbedPane() {
        this.tabs = new JTabbedPane(1, 0);
        this.tabs.setAlignmentX(0.0f);
        Font font = (Font)TreeViewerAgent.getRegistry().lookup("/resources/fonts/Titles");
        this.tabs.setFont(font);
        this.tabs.setForeground(UIUtilities.STEELBLUE);
        Map browsers = this.model.getBrowsers();
        Browser browser = (Browser)browsers.get(new Integer(100));
        if (browser.isDisplayed()) {
            this.tabs.addTab(browser.getTitle(), browser.getIcon(), browser.getUI());
        }
        if ((browser = (Browser)browsers.get(new Integer(101))).isDisplayed()) {
            this.tabs.addTab(browser.getTitle(), browser.getIcon(), browser.getUI());
        }
        if ((browser = (Browser)browsers.get(new Integer(102))).isDisplayed()) {
            this.tabs.addTab(browser.getTitle(), browser.getIcon(), browser.getUI());
        }
    }

    private JMenuBar createMenuBar() {
        int i;
        TaskBar tb = TreeViewerAgent.getRegistry().getTaskBar();
        JMenu[] menus = new JMenu[]{this.createFileMenu(), this.createEditMenu(), this.createViewMenu()};
        JMenuBar bar = tb.getTaskBarMenuBar();
        JMenu[] existingMenus = new JMenu[bar.getMenuCount()];
        for (i = 0; i < existingMenus.length; ++i) {
            existingMenus[i] = bar.getMenu(i);
        }
        bar.removeAll();
        for (int j = 0; j < menus.length; ++j) {
            bar.add(menus[j]);
        }
        for (i = 0; i < existingMenus.length; ++i) {
            bar.add(existingMenus[i]);
        }
        return bar;
    }

    private JMenu createViewMenu() {
        JMenu menu = new JMenu("View");
        menu.setMnemonic(86);
        JCheckBoxMenuItem item = new JCheckBoxMenuItem();
        Map browsers = this.model.getBrowsers();
        Browser browser = (Browser)browsers.get(new Integer(100));
        item.setSelected(browser.isDisplayed());
        item.setAction(this.controller.getAction(TreeViewerControl.HIERARCHY_EXPLORER));
        menu.add(item);
        item = new JCheckBoxMenuItem();
        browser = (Browser)browsers.get(new Integer(101));
        item.setSelected(browser.isDisplayed());
        item.setAction(this.controller.getAction(TreeViewerControl.CATEGORY_EXPLORER));
        menu.add(item);
        item = new JCheckBoxMenuItem();
        browser = (Browser)browsers.get(new Integer(102));
        item.setSelected(browser.isDisplayed());
        item.setAction(this.controller.getAction(TreeViewerControl.IMAGES_EXPLORER));
        menu.add(item);
        return menu;
    }

    private JMenu createFileMenu() {
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        TreeViewerAction a = this.controller.getAction(TreeViewerControl.CREATE_TOP_CONTAINER);
        JMenuItem item = new JMenuItem(a);
        item.setText(a.getActionName());
        this.menuItems.add(item);
        menu.add(item);
        a = this.controller.getAction(TreeViewerControl.CREATE_OBJECT);
        item = new JMenuItem(a);
        menu.add(item);
        item.setText(a.getActionName());
        this.menuItems.add(item);
        a = this.controller.getAction(TreeViewerControl.SWITCH_USER);
        item = new JMenuItem(a);
        menu.add(item);
        item.setText(a.getActionName());
        menu.add(new JSeparator(0));
        a = this.controller.getAction(TreeViewerControl.VIEW);
        item = new JMenuItem(a);
        item.setText(a.getActionName());
        this.menuItems.add(item);
        menu.add(item);
        a = this.controller.getAction(TreeViewerControl.REFRESH_TREE);
        item = new JMenuItem(a);
        item.setText(a.getActionName());
        menu.add(item);
        menu.add(new JSeparator(0));
        menu.add(new JMenuItem(this.controller.getAction(TreeViewerControl.EXIT)));
        return menu;
    }

    private JMenu createEditMenu() {
        JMenu menu = new JMenu("Edit");
        menu.setMnemonic(69);
        menu.add(new JMenuItem(this.controller.getAction(TreeViewerControl.CUT_OBJECT)));
        menu.add(new JMenuItem(this.controller.getAction(TreeViewerControl.COPY_OBJECT)));
        menu.add(new JMenuItem(this.controller.getAction(TreeViewerControl.PASTE_OBJECT)));
        menu.add(new JMenuItem(this.controller.getAction(TreeViewerControl.DELETE_OBJECT)));
        menu.add(new JSeparator(0));
        menu.add(new JMenuItem(this.controller.getAction(TreeViewerControl.FIND)));
        menu.add(new JMenuItem(this.controller.getAction(TreeViewerControl.CLEAR)));
        menu.add(new JSeparator(0));
        menu.add(new JMenuItem(this.controller.getAction(TreeViewerControl.CLASSIFY)));
        menu.add(new JMenuItem(this.controller.getAction(TreeViewerControl.DECLASSIFY)));
        TreeViewerAction a = this.controller.getAction(TreeViewerControl.ANNOTATE);
        JMenuItem item = new JMenuItem(a);
        item.setText(a.getActionName());
        this.menuItems.add(item);
        menu.add(item);
        menu.add(new JSeparator(0));
        a = this.controller.getAction(TreeViewerControl.PROPERTIES);
        item = new JMenuItem(a);
        item.setText(a.getActionName());
        this.menuItems.add(item);
        menu.add(item);
        return menu;
    }

    private void initComponents() {
        this.createTabbedPane();
        this.workingPane = new JScrollPane();
    }

    private void buildGUI() {
        this.splitPane = new JSplitPane();
        this.splitPane.setOrientation(1);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setLeftComponent(this.tabs);
        this.splitPane.setRightComponent(this.workingPane);
        this.splitPane.setDividerLocation(300);
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout(0, 0));
        c.add((Component)this.toolBar, "North");
        c.add((Component)this.splitPane, "Center");
        c.add((Component)this.statusBar, "South");
    }

    TreeViewerWin() {
        super(TITLE);
    }

    void initialize(TreeViewerControl controller, TreeViewerModel model, Rectangle bounds) {
        this.controller = controller;
        this.invokerBounds = bounds;
        this.model = model;
        this.statusBar = new StatusBar(controller);
        this.statusBar.addPropertyChangeListener(controller);
        this.toolBar = new ToolBar(controller);
        this.initComponents();
        this.setJMenuBar(this.createMenuBar());
        this.buildGUI();
        controller.attachUIListeners(this.tabs);
        String title = model.getExperimenterNames() + "'s ";
        this.setTitle(title + TITLE);
    }

    void closeViewer() {
        this.setVisible(false);
        this.dispose();
    }

    void addBrowser(Browser browser) {
        if (!this.isBrowserVisible(browser)) {
            this.tabs.addTab(browser.getTitle(), browser.getIcon(), browser.getUI());
        }
        this.tabs.removeChangeListener(this.controller.getTabbedListener());
        this.tabs.setSelectedComponent(browser.getUI());
        this.tabs.addChangeListener(this.controller.getTabbedListener());
    }

    void removeBrowser(Browser browser) {
        if (this.isBrowserVisible(browser)) {
            this.tabs.remove(browser.getUI());
            Component c = this.tabs.getSelectedComponent();
            if (c == null) {
                this.model.setSelectedBrowser(null);
                return;
            }
            Map browsers = this.model.getBrowsers();
            Iterator i = browsers.values().iterator();
            boolean selected = false;
            while (i.hasNext()) {
                browser = (Browser)i.next();
                if (!c.equals(browser.getUI())) continue;
                this.model.setSelectedBrowser(browser);
                selected = true;
                break;
            }
            if (!selected) {
                this.model.setSelectedBrowser(null);
            }
        }
    }

    void showPopup(Component c, Point p) {
        PopupMenu popupMenu = new PopupMenu(this.controller);
        popupMenu.show(c, p.x, p.y);
    }

    void addComponent(JComponent component) {
        JViewport viewPort = this.workingPane.getViewport();
        component.setPreferredSize(viewPort.getExtentSize());
        viewPort.removeAll();
        viewPort.add(component);
        viewPort.validate();
    }

    void removeAllFromWorkingPane() {
        JViewport viewPort = this.workingPane.getViewport();
        if (viewPort.getComponents().length != 0) {
            viewPort.removeAll();
            viewPort.repaint();
        }
    }

    void showFinder(boolean b) {
        JSplitPane pane = null;
        if (b) {
            pane = new JSplitPane();
            pane.setOrientation(0);
            pane.setResizeWeight(1.0);
            pane.setOneTouchExpandable(true);
            pane.setContinuousLayout(true);
            pane.setTopComponent(this.splitPane);
            pane.setBottomComponent(this.model.getFinder());
        } else {
            pane = this.splitPane;
        }
        Container c = this.getContentPane();
        c.removeAll();
        c.add((Component)this.toolBar, "North");
        c.add((Component)pane, "Center");
        c.add((Component)this.statusBar, "South");
        c.validate();
    }

    void showMenu(int menuID, Component c, Point p) {
        switch (menuID) {
            case 0: {
                this.toolBar.showManagementMenu(c, p);
                break;
            }
            case 1: {
                this.toolBar.showClassifyMenu(c, p);
            }
        }
    }

    void onStateChanged(boolean b) {
        Map browsers = this.model.getBrowsers();
        if (browsers != null) {
            Iterator i = browsers.keySet().iterator();
            while (i.hasNext()) {
                ((Browser)browsers.get(i.next())).onComponentStateChange(b);
            }
        }
        this.tabs.setEnabled(b);
    }

    void setStatus(String text, boolean hide) {
        this.statusBar.setStatus(text);
        this.statusBar.setProgress(hide);
    }

    void setStatusIcon(boolean b) {
        if (b) {
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.statusBar.setStatusIcon(b);
    }

    DataHandler getDataHandler() {
        return this.model.getDataHandler();
    }

    void discardDataHandler() {
        this.model.discardDataHandler();
    }

    void updateMenuItems() {
        for (JMenuItem item : this.menuItems) {
            TreeViewerAction a = (TreeViewerAction)item.getAction();
            item.setText(a.getActionName());
            item.setToolTipText(a.getActionDescription());
        }
    }

    public void setOnScreen() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(8 * (screenSize.width / 10), 8 * (screenSize.height / 10));
        UIUtilities.incrementRelativeToAndShow(this.invokerBounds, this);
        this.invokerBounds = null;
    }
}

