/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.view;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import org.openmicroscopy.shoola.agents.treeviewer.AdminLoader;
import org.openmicroscopy.shoola.agents.treeviewer.DataObjectRemover;
import org.openmicroscopy.shoola.agents.treeviewer.DataObjectUpdater;
import org.openmicroscopy.shoola.agents.treeviewer.DataTreeViewerLoader;
import org.openmicroscopy.shoola.agents.treeviewer.ExistingObjectsLoader;
import org.openmicroscopy.shoola.agents.treeviewer.ExistingObjectsSaver;
import org.openmicroscopy.shoola.agents.treeviewer.ThumbnailLoader;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.browser.BrowserFactory;
import org.openmicroscopy.shoola.agents.treeviewer.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.treeviewer.editors.Editor;
import org.openmicroscopy.shoola.agents.treeviewer.finder.Finder;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerFactory;
import org.openmicroscopy.shoola.agents.util.DataHandler;
import org.openmicroscopy.shoola.agents.util.annotator.view.AnnotatorFactory;
import org.openmicroscopy.shoola.agents.util.classifier.view.ClassifierFactory;
import pojos.CategoryData;
import pojos.CategoryGroupData;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ExperimenterData;
import pojos.ImageData;
import pojos.ProjectData;

class TreeViewerModel {
    private int state = 1;
    private DataTreeViewerLoader currentLoader;
    private Map<Integer, Browser> browsers;
    private Browser selectedBrowser;
    private int editorType = 101;
    private long rootID;
    private long userGroupID;
    private ExperimenterData experimenter;
    private Finder finder;
    private TreeImageDisplay[] nodesToCopy;
    private int copyIndex;
    private Editor editor;
    private DataHandler dataHandler;
    private boolean recycled;
    private boolean rollOver;
    protected TreeViewer component;

    private Map buildCopyMap(TreeImageDisplay[] parents) {
        Object uo = this.nodesToCopy[0].getUserObject();
        Object uoParent = parents[0].getUserObject();
        if (!(uo instanceof DataObject)) {
            return null;
        }
        if (!(uoParent instanceof DataObject)) {
            return null;
        }
        DataObject obj = (DataObject)uo;
        DataObject objParent = (DataObject)uoParent;
        if (objParent instanceof ProjectData && obj instanceof DatasetData || objParent instanceof CategoryGroupData && obj instanceof CategoryData || objParent instanceof CategoryData && obj instanceof ImageData || objParent instanceof DatasetData && obj instanceof ImageData) {
            HashMap map = new HashMap(parents.length);
            for (int i = 0; i < parents.length; ++i) {
                HashSet<Object> children = new HashSet<Object>(this.nodesToCopy.length);
                for (int j = 0; j < this.nodesToCopy.length; ++j) {
                    children.add(this.nodesToCopy[j].getUserObject());
                }
                map.put(parents[i].getUserObject(), children);
            }
            return map;
        }
        return null;
    }

    private Map buildCutMap(TreeImageDisplay[] nodes) {
        HashMap<Object, HashSet<Object>> map = new HashMap<Object, HashSet<Object>>();
        for (int i = 0; i < nodes.length; ++i) {
            TreeImageDisplay child = nodes[i];
            TreeImageDisplay parent = child.getParentDisplay();
            Object po = parent.getUserObject();
            HashSet<Object> children = (HashSet<Object>)map.get(po);
            if (children == null) {
                children = new HashSet<Object>();
                map.put(po, children);
            }
            children.add(nodes[i].getUserObject());
        }
        return map;
    }

    private void createBrowsers() {
        Browser browser;
        this.selectedBrowser = browser = BrowserFactory.createBrowser(100, this.component, this.experimenter);
        browser.setSelected(true);
        this.browsers.put(new Integer(100), browser);
        browser = BrowserFactory.createBrowser(101, this.component, this.experimenter);
        this.browsers.put(new Integer(101), browser);
        browser = BrowserFactory.createBrowser(102, this.component, this.experimenter);
        this.browsers.put(new Integer(102), browser);
    }

    protected TreeViewerModel() {
        this.browsers = new HashMap<Integer, Browser>();
        this.recycled = false;
    }

    protected TreeViewerModel(ExperimenterData exp, long userGroupID) {
        this.recycled = false;
        this.experimenter = exp;
        this.browsers = new HashMap<Integer, Browser>();
        this.setHierarchyRoot(exp.getId(), userGroupID);
    }

    void initialize(TreeViewer component) {
        this.component = component;
        this.createBrowsers();
    }

    void setHierarchyRoot(long rootID, long userGroupID) {
        this.rootID = rootID;
        this.userGroupID = userGroupID;
    }

    boolean isSameDisplay(TreeViewerModel other) {
        if (other == null) {
            return false;
        }
        return other.rootID == this.rootID && other.userGroupID == this.userGroupID;
    }

    boolean isRecycled() {
        return this.recycled;
    }

    void setRecycled(boolean b) {
        this.recycled = b;
    }

    long getUserGroupID() {
        return this.userGroupID;
    }

    long getRootID() {
        return this.rootID;
    }

    void setSelectedBrowser(Browser browser) {
        this.selectedBrowser = browser;
    }

    Browser getSelectedBrowser() {
        return this.selectedBrowser;
    }

    Map getBrowsers() {
        return this.browsers;
    }

    int getState() {
        return this.state;
    }

    void discard() {
        this.cancel();
        this.state = 2;
    }

    void cancel() {
        if (this.currentLoader != null) {
            this.currentLoader.cancel();
            this.currentLoader = null;
        }
        this.state = 7;
    }

    void fireDataObjectsDeletion(TreeImageDisplay node) {
        this.state = 3;
        TreeImageDisplay parent = node.getParentDisplay();
        DataObject object = (DataObject)node.getUserObject();
        Object po = parent.getUserObject();
        DataObject data = null;
        if (!(object instanceof ProjectData) && !(object instanceof CategoryGroupData)) {
            data = (DataObject)po;
        }
        HashSet<DataObject> l = new HashSet<DataObject>(1);
        l.add(object);
        this.currentLoader = new DataObjectRemover(this.component, l, data);
        this.currentLoader.load();
    }

    void fireDataObjectsDeletion(List nodes) {
        this.state = 3;
        Iterator i = nodes.iterator();
        HashMap<DataObject, HashSet<DataObject>> map = null;
        HashSet<DataObject> toRemove = null;
        while (i.hasNext()) {
            HashSet<DataObject> l;
            TreeImageDisplay n = (TreeImageDisplay)i.next();
            TreeImageDisplay parent = n.getParentDisplay();
            if (!(n.getUserObject() instanceof DataObject)) continue;
            DataObject object = (DataObject)n.getUserObject();
            if (object instanceof ProjectData || object instanceof CategoryGroupData) {
                if (toRemove == null) {
                    toRemove = new HashSet<DataObject>();
                }
                toRemove.add(object);
                continue;
            }
            DataObject po = (DataObject)parent.getUserObject();
            if (map == null) {
                map = new HashMap<DataObject, HashSet<DataObject>>();
            }
            if ((l = (HashSet<DataObject>)map.get(po)) == null) {
                l = new HashSet<DataObject>();
            }
            l.add(object);
            map.put(po, l);
        }
        if (toRemove != null) {
            this.currentLoader = new DataObjectRemover(this.component, toRemove, null);
            this.currentLoader.load();
        } else {
            this.currentLoader = new DataObjectRemover(this.component, map);
            this.currentLoader.load();
        }
    }

    void fireThumbnailLoading(ImageData image) {
        this.state = 4;
        this.currentLoader = new ThumbnailLoader(this.component, image);
        this.currentLoader.load();
    }

    void setEditorType(int editorType) {
        this.editorType = editorType;
        this.editor = null;
    }

    void setEditor(Editor editor) {
        this.editor = editor;
    }

    Editor getEditor() {
        return this.editor;
    }

    int getEditorType() {
        return this.editorType;
    }

    Finder getFinder() {
        return this.finder;
    }

    void setFinder(Finder finder) {
        this.finder = finder;
    }

    ExperimenterData getUserDetails() {
        return (ExperimenterData)TreeViewerAgent.getRegistry().lookup("/current_user/details");
    }

    void setState(int state) {
        this.state = state;
    }

    void fireDataExistingObjectsLoader(DataObject ho) {
        this.state = 5;
        this.currentLoader = new ExistingObjectsLoader(this.component, ho);
        this.currentLoader.load();
    }

    void fireAddExistingObjects(Set children) {
        TreeImageDisplay parent = this.selectedBrowser.getLastSelectedDisplay();
        if (parent == null) {
            return;
        }
        Object po = parent.getUserObject();
        if (po instanceof ProjectData || po instanceof DatasetData || po instanceof CategoryGroupData) {
            this.currentLoader = new ExistingObjectsSaver(this.component, (DataObject)po, children);
            this.currentLoader.load();
        }
        this.state = 7;
    }

    void setNodesToCopy(TreeImageDisplay[] nodes, int index) {
        this.copyIndex = index;
        this.nodesToCopy = nodes;
    }

    TreeImageDisplay[] getNodesToCopy() {
        return this.nodesToCopy;
    }

    boolean paste(TreeImageDisplay[] parents) {
        Map map = this.buildCopyMap(parents);
        if (map == null) {
            return false;
        }
        if (this.copyIndex == 400) {
            this.currentLoader = new DataObjectUpdater(this.component, map, 0);
        } else if (this.copyIndex == 401) {
            Map toRemove = this.buildCutMap(this.nodesToCopy);
            this.currentLoader = new DataObjectUpdater(this.component, map, toRemove, 1);
        }
        this.currentLoader.load();
        this.state = 3;
        this.nodesToCopy = null;
        return true;
    }

    DataHandler annotateDataObjects(JFrame owner, TreeImageDisplay[] nodes) {
        HashSet<Object> toAnnotate = new HashSet<Object>();
        Class<ImageData> type = null;
        for (int i = 0; i < nodes.length; ++i) {
            Object uo = nodes[i].getUserObject();
            if (uo instanceof ImageData) {
                type = ImageData.class;
                toAnnotate.add(uo);
                continue;
            }
            if (!(uo instanceof DatasetData)) continue;
            type = DatasetData.class;
            toAnnotate.add(uo);
        }
        this.dataHandler = AnnotatorFactory.getAnnotator(owner, toAnnotate, TreeViewerAgent.getRegistry(), type);
        return this.dataHandler;
    }

    DataHandler annotateChildren(JFrame owner, TreeImageDisplay node) {
        Object uo = node.getUserObject();
        HashSet<Object> toAnnotate = new HashSet<Object>();
        if (uo instanceof CategoryData) {
            toAnnotate.add(uo);
            this.dataHandler = AnnotatorFactory.getChildrenAnnotator(owner, toAnnotate, TreeViewerAgent.getRegistry(), CategoryData.class);
            return this.dataHandler;
        }
        if (uo instanceof DatasetData) {
            toAnnotate.add(uo);
            this.dataHandler = AnnotatorFactory.getChildrenAnnotator(owner, toAnnotate, TreeViewerAgent.getRegistry(), DatasetData.class);
            return this.dataHandler;
        }
        return null;
    }

    DataHandler classifyImageObjects(JFrame owner, ImageData[] nodes, int mode) {
        HashSet<ImageData> images = new HashSet<ImageData>(nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            images.add(nodes[i]);
        }
        this.dataHandler = ClassifierFactory.getClassifier(owner, images, this.rootID, mode, TreeViewerAgent.getRegistry());
        return this.dataHandler;
    }

    DataHandler classifyChildren(JFrame owner, TreeImageDisplay node) {
        Object uo = node.getUserObject();
        if (uo instanceof DatasetData || uo instanceof CategoryData) {
            HashSet<DataObject> folders = new HashSet<DataObject>(1);
            folders.add((DataObject)uo);
            this.dataHandler = ClassifierFactory.getChildrenClassifier(owner, folders, this.rootID, TreeViewerAgent.getRegistry());
            return this.dataHandler;
        }
        return null;
    }

    void discardDataHandler() {
        if (this.dataHandler != null) {
            this.dataHandler.discard();
            this.dataHandler = null;
        }
    }

    DataHandler getDataHandler() {
        return this.dataHandler;
    }

    void setExperimenter(ExperimenterData experimenter) {
        this.experimenter = experimenter;
        Set<Integer> keys = this.browsers.keySet();
        Iterator<Integer> i = keys.iterator();
        while (i.hasNext()) {
            Browser browser = this.browsers.get(i.next());
            browser.setRootNode(experimenter);
        }
    }

    void fireUserGroupsRetrieval() {
        this.state = 5;
        this.currentLoader = new AdminLoader(this.component);
        this.currentLoader.load();
    }

    void setUserGroups(Map groups) {
        this.state = 7;
        TreeViewerFactory.setUserGroups(groups);
    }

    Map getAvailableUserGroups() {
        return TreeViewerFactory.getAvailableUserGroups();
    }

    String getExperimenterNames() {
        ExperimenterData exp = this.getExperimenter();
        return exp.getFirstName() + " " + exp.getLastName();
    }

    ExperimenterData getExperimenter() {
        if (this.experimenter == null) {
            this.experimenter = this.getUserDetails();
        }
        return this.experimenter;
    }

    boolean isRollOver() {
        return this.rollOver;
    }

    void setRollOver(boolean rollOver) {
        this.rollOver = rollOver;
    }
}

