/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.view;

import java.awt.Rectangle;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.agents.hiviewer.HiViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerComponent;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewerModel;
import org.openmicroscopy.shoola.env.ui.TaskBar;
import pojos.ExperimenterData;

public class TreeViewerFactory
implements ChangeListener {
    private static final TreeViewerFactory singleton = new TreeViewerFactory();
    private TreeViewer viewer = null;
    private Set<TreeViewer> viewers = new HashSet<TreeViewer>();
    private JMenu windowMenu = new JMenu("DataManagers");
    private Map availableUserGroups;
    private boolean isAttached = false;

    static JMenu getWindowMenu() {
        return TreeViewerFactory.singleton.windowMenu;
    }

    static boolean isWindowMenuAttachedToTaskBar() {
        return TreeViewerFactory.singleton.isAttached;
    }

    static void attachWindowMenuToTaskBar() {
        if (TreeViewerFactory.isWindowMenuAttachedToTaskBar()) {
            return;
        }
        TaskBar tb = HiViewerAgent.getRegistry().getTaskBar();
        tb.addToMenu(0, TreeViewerFactory.singleton.windowMenu);
        TreeViewerFactory.singleton.isAttached = true;
    }

    static Set getViewers() {
        return TreeViewerFactory.singleton.viewers;
    }

    static boolean isLastViewer() {
        return TreeViewerFactory.singleton.viewers.size() <= 1;
    }

    public static TreeViewer getTreeViewer(ExperimenterData exp, long userGroupID) {
        TreeViewerModel model = new TreeViewerModel(exp, userGroupID);
        return singleton.getTreeViewer(model, null);
    }

    public static TreeViewer getTreeViewer(ExperimenterData exp, long userGroupID, Rectangle bounds) {
        TreeViewerModel model = new TreeViewerModel(exp, userGroupID);
        return singleton.getTreeViewer(model, bounds);
    }

    static final Map getAvailableUserGroups() {
        return TreeViewerFactory.singleton.availableUserGroups;
    }

    static final void setUserGroups(Map groups) {
        if (TreeViewerFactory.singleton.availableUserGroups == null) {
            TreeViewerFactory.singleton.availableUserGroups = groups;
        }
    }

    private TreeViewerFactory() {
    }

    private TreeViewer getTreeViewer(TreeViewerModel model, Rectangle bounds) {
        for (TreeViewerComponent treeViewerComponent : this.viewers) {
            if (!model.isSameDisplay(treeViewerComponent.getModel())) continue;
            treeViewerComponent.setRecycled(true);
            return treeViewerComponent;
        }
        TreeViewerComponent treeViewerComponent = new TreeViewerComponent(model);
        model.initialize(treeViewerComponent);
        treeViewerComponent.initialize(bounds);
        treeViewerComponent.addChangeListener(this);
        this.viewers.add(treeViewerComponent);
        return treeViewerComponent;
    }

    public void stateChanged(ChangeEvent ce) {
        TreeViewerComponent comp = (TreeViewerComponent)ce.getSource();
        if (comp.getState() == 2) {
            this.viewers.remove(comp);
        }
    }
}

